/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.io.IOException;
import org.apache.skywalking.oap.server.core.register.NetworkAddressInventory;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.cache.INetworkAddressInventoryCacheDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2SQLExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2NetworkAddressInventoryCacheDAO
extends H2SQLExecutor
implements INetworkAddressInventoryCacheDAO {
    private static final Logger logger = LoggerFactory.getLogger(H2NetworkAddressInventoryCacheDAO.class);
    private JDBCHikariCPClient h2Client;

    public H2NetworkAddressInventoryCacheDAO(JDBCHikariCPClient h2Client) {
        this.h2Client = h2Client;
    }

    public int getAddressId(String networkAddress) {
        String id = NetworkAddressInventory.buildId((String)networkAddress);
        return this.getEntityIDByID(this.h2Client, "sequence", "network_address_inventory", id);
    }

    public NetworkAddressInventory get(int addressId) {
        try {
            return (NetworkAddressInventory)this.getByColumn(this.h2Client, "network_address_inventory", "sequence", addressId, (StorageBuilder)new NetworkAddressInventory.Builder());
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

