/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.io.IOException;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.storage.IMetricsDAO;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.SQLExecutor;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2SQLExecutor;

public class H2MetricsDAO
extends H2SQLExecutor
implements IMetricsDAO<SQLExecutor, SQLExecutor> {
    private JDBCHikariCPClient h2Client;
    private StorageBuilder<Metrics> storageBuilder;

    public H2MetricsDAO(JDBCHikariCPClient h2Client, StorageBuilder<Metrics> storageBuilder) {
        this.h2Client = h2Client;
        this.storageBuilder = storageBuilder;
    }

    public Metrics get(Model model, Metrics metrics) throws IOException {
        return (Metrics)this.getByID(this.h2Client, model.getName(), metrics.id(), this.storageBuilder);
    }

    public SQLExecutor prepareBatchInsert(Model model, Metrics metrics) throws IOException {
        return this.getInsertExecutor(model.getName(), (StorageData)metrics, this.storageBuilder);
    }

    public SQLExecutor prepareBatchUpdate(Model model, Metrics metrics) throws IOException {
        return this.getUpdateExecutor(model.getName(), (StorageData)metrics, this.storageBuilder);
    }
}

