/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.skywalking.oap.server.core.storage.IBatchDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.JDBCClientException;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.SQLExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2BatchDAO
implements IBatchDAO {
    private static final Logger logger = LoggerFactory.getLogger(H2BatchDAO.class);
    private JDBCHikariCPClient h2Client;

    public H2BatchDAO(JDBCHikariCPClient h2Client) {
        this.h2Client = h2Client;
    }

    public void batchPersistence(List<?> batchCollection) {
        if (batchCollection.size() == 0) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("batch sql statements execute, data size: {}", (Object)batchCollection.size());
        }
        try (Connection connection = this.h2Client.getConnection();){
            for (Object exe : batchCollection) {
                SQLExecutor sqlExecutor = (SQLExecutor)exe;
                sqlExecutor.invoke(connection);
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (JDBCClientException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

