/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.Downsampling;
import org.apache.skywalking.oap.server.core.analysis.manual.RelationDefineUtil;
import org.apache.skywalking.oap.server.core.query.entity.Call;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.storage.model.ModelName;
import org.apache.skywalking.oap.server.core.storage.query.ITopologyQueryDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class TopologyQueryEsDAO
extends EsDAO
implements ITopologyQueryDAO {
    public TopologyQueryEsDAO(ElasticSearchClient client) {
        super(client);
    }

    public List<Call.CallDetail> loadSpecifiedServerSideServiceRelations(Downsampling downsampling, long startTB, long endTB, List<Integer> serviceIds) throws IOException {
        if (CollectionUtils.isEmpty(serviceIds)) {
            throw new UnexpectedException("Service id is empty");
        }
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        sourceBuilder.size(0);
        this.setQueryCondition(sourceBuilder, startTB, endTB, serviceIds);
        String indexName = ModelName.build((Downsampling)downsampling, (String)"service_relation_server_side");
        return this.load(sourceBuilder, indexName, DetectPoint.SERVER);
    }

    public List<Call.CallDetail> loadSpecifiedClientSideServiceRelations(Downsampling downsampling, long startTB, long endTB, List<Integer> serviceIds) throws IOException {
        if (CollectionUtils.isEmpty(serviceIds)) {
            throw new UnexpectedException("Service id is empty");
        }
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        sourceBuilder.size(0);
        this.setQueryCondition(sourceBuilder, startTB, endTB, serviceIds);
        String indexName = ModelName.build((Downsampling)downsampling, (String)"service_relation_client_side");
        return this.load(sourceBuilder, indexName, DetectPoint.CLIENT);
    }

    private void setQueryCondition(SearchSourceBuilder sourceBuilder, long startTB, long endTB, List<Integer> serviceIds) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must().add(QueryBuilders.rangeQuery((String)"time_bucket").gte((Object)startTB).lte((Object)endTB));
        BoolQueryBuilder serviceIdBoolQuery = QueryBuilders.boolQuery();
        boolQuery.must().add(serviceIdBoolQuery);
        if (serviceIds.size() == 1) {
            serviceIdBoolQuery.should().add(QueryBuilders.termQuery((String)"source_service_id", (Object)serviceIds.get(0)));
            serviceIdBoolQuery.should().add(QueryBuilders.termQuery((String)"dest_service_id", (Object)serviceIds.get(0)));
        } else {
            serviceIdBoolQuery.should().add(QueryBuilders.termsQuery((String)"source_service_id", serviceIds));
            serviceIdBoolQuery.should().add(QueryBuilders.termsQuery((String)"dest_service_id", serviceIds));
        }
        sourceBuilder.query((QueryBuilder)boolQuery);
    }

    public List<Call.CallDetail> loadServerSideServiceRelations(Downsampling downsampling, long startTB, long endTB) throws IOException {
        String indexName = ModelName.build((Downsampling)downsampling, (String)"service_relation_server_side");
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        sourceBuilder.query((QueryBuilder)QueryBuilders.rangeQuery((String)"time_bucket").gte((Object)startTB).lte((Object)endTB));
        sourceBuilder.size(0);
        return this.load(sourceBuilder, indexName, DetectPoint.SERVER);
    }

    public List<Call.CallDetail> loadClientSideServiceRelations(Downsampling downsampling, long startTB, long endTB) throws IOException {
        String indexName = ModelName.build((Downsampling)downsampling, (String)"service_relation_client_side");
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        sourceBuilder.query((QueryBuilder)QueryBuilders.rangeQuery((String)"time_bucket").gte((Object)startTB).lte((Object)endTB));
        sourceBuilder.size(0);
        return this.load(sourceBuilder, indexName, DetectPoint.CLIENT);
    }

    public List<Call.CallDetail> loadSpecifiedDestOfServerSideEndpointRelations(Downsampling downsampling, long startTB, long endTB, int destEndpointId) throws IOException {
        String indexName = ModelName.build((Downsampling)downsampling, (String)"endpoint_relation_server_side");
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        sourceBuilder.size(0);
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must().add(QueryBuilders.rangeQuery((String)"time_bucket").gte((Object)startTB).lte((Object)endTB));
        BoolQueryBuilder serviceIdBoolQuery = QueryBuilders.boolQuery();
        boolQuery.must().add(serviceIdBoolQuery);
        serviceIdBoolQuery.should().add(QueryBuilders.termQuery((String)"source_endpoint_id", (int)destEndpointId));
        serviceIdBoolQuery.should().add(QueryBuilders.termQuery((String)"dest_endpoint_id", (int)destEndpointId));
        sourceBuilder.query((QueryBuilder)boolQuery);
        return this.load(sourceBuilder, indexName, DetectPoint.SERVER);
    }

    private List<Call.CallDetail> load(SearchSourceBuilder sourceBuilder, String indexName, DetectPoint detectPoint) throws IOException {
        sourceBuilder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"entity_id").field("entity_id")).size(1000));
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(indexName, sourceBuilder);
        ArrayList<Call.CallDetail> calls = new ArrayList<Call.CallDetail>();
        Terms entityTerms = (Terms)response.getAggregations().get("entity_id");
        for (Terms.Bucket entityBucket : entityTerms.getBuckets()) {
            String entityId = entityBucket.getKeyAsString();
            RelationDefineUtil.RelationDefine relationDefine = RelationDefineUtil.splitEntityId((String)entityId);
            Call.CallDetail call = new Call.CallDetail();
            call.setSource(Integer.valueOf(relationDefine.getSource()));
            call.setTarget(Integer.valueOf(relationDefine.getDest()));
            call.setComponentId(Integer.valueOf(relationDefine.getComponentId()));
            call.setDetectPoint(detectPoint);
            call.generateID();
            calls.add(call);
        }
        return calls;
    }
}

