/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.oap.server.core.query.entity.Order;
import org.apache.skywalking.oap.server.core.query.entity.TopNRecord;
import org.apache.skywalking.oap.server.core.storage.query.ITopNRecordsQueryDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class TopNRecordsQueryEsDAO
extends EsDAO
implements ITopNRecordsQueryDAO {
    public TopNRecordsQueryEsDAO(ElasticSearchClient client) {
        super(client);
    }

    public List<TopNRecord> getTopNRecords(long startSecondTB, long endSecondTB, String metricName, int serviceId, int topN, Order order) throws IOException {
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must().add(QueryBuilders.rangeQuery((String)"time_bucket").gte((Object)startSecondTB).lte((Object)endSecondTB));
        boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"service_id", (int)serviceId));
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        sourceBuilder.size(topN).sort("latency", order.equals((Object)Order.DES) ? SortOrder.DESC : SortOrder.ASC);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(metricName, sourceBuilder);
        ArrayList<TopNRecord> results = new ArrayList<TopNRecord>();
        for (SearchHit searchHit : response.getHits().getHits()) {
            TopNRecord record = new TopNRecord();
            record.setStatement((String)searchHit.getSourceAsMap().get("statement"));
            record.setTraceId((String)searchHit.getSourceAsMap().get("trace_id"));
            record.setLatency(((Number)searchHit.getSourceAsMap().get("latency")).longValue());
            results.add(record);
        }
        return results;
    }
}

