/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.oap.server.core.analysis.Downsampling;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntKeyLongValue;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntKeyLongValueArray;
import org.apache.skywalking.oap.server.core.query.entity.IntValues;
import org.apache.skywalking.oap.server.core.query.entity.KVInt;
import org.apache.skywalking.oap.server.core.query.entity.Thermodynamic;
import org.apache.skywalking.oap.server.core.query.sql.Function;
import org.apache.skywalking.oap.server.core.query.sql.Where;
import org.apache.skywalking.oap.server.core.storage.model.ModelName;
import org.apache.skywalking.oap.server.core.storage.query.IMetricsQueryDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.avg.Avg;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class MetricsQueryEsDAO
extends EsDAO
implements IMetricsQueryDAO {
    public MetricsQueryEsDAO(ElasticSearchClient client) {
        super(client);
    }

    public IntValues getValues(String indName, Downsampling downsampling, long startTB, long endTB, Where where, String valueCName, Function function) throws IOException {
        String indexName = ModelName.build((Downsampling)downsampling, (String)indName);
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        this.queryBuild(sourceBuilder, where, startTB, endTB);
        TermsAggregationBuilder entityIdAggregation = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"entity_id").field("entity_id")).size(1000);
        this.functionAggregation(function, entityIdAggregation, valueCName);
        sourceBuilder.aggregation((AggregationBuilder)entityIdAggregation);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(indexName, sourceBuilder);
        IntValues intValues = new IntValues();
        Terms idTerms = (Terms)response.getAggregations().get("entity_id");
        for (Terms.Bucket idBucket : idTerms.getBuckets()) {
            long value;
            switch (function) {
                case Sum: {
                    Sum sum = (Sum)idBucket.getAggregations().get(valueCName);
                    value = (long)sum.getValue();
                    break;
                }
                case Avg: {
                    Avg avg = (Avg)idBucket.getAggregations().get(valueCName);
                    value = (long)avg.getValue();
                    break;
                }
                default: {
                    Avg avg = (Avg)idBucket.getAggregations().get(valueCName);
                    value = (long)avg.getValue();
                }
            }
            KVInt kvInt = new KVInt();
            kvInt.setId(idBucket.getKeyAsString());
            kvInt.setValue(value);
            intValues.getValues().add(kvInt);
        }
        return intValues;
    }

    private void functionAggregation(Function function, TermsAggregationBuilder parentAggBuilder, String valueCName) {
        switch (function) {
            case Avg: {
                parentAggBuilder.subAggregation((AggregationBuilder)AggregationBuilders.avg((String)valueCName).field(valueCName));
                break;
            }
            case Sum: {
                parentAggBuilder.subAggregation((AggregationBuilder)AggregationBuilders.sum((String)valueCName).field(valueCName));
                break;
            }
            default: {
                parentAggBuilder.subAggregation((AggregationBuilder)AggregationBuilders.avg((String)valueCName).field(valueCName));
            }
        }
    }

    public IntValues getLinearIntValues(String indName, Downsampling downsampling, List<String> ids, String valueCName) throws IOException {
        String indexName = ModelName.build((Downsampling)downsampling, (String)indName);
        Map response = ((ElasticSearchClient)this.getClient()).ids(indexName, ids.toArray(new String[0]));
        IntValues intValues = new IntValues();
        for (String id : ids) {
            KVInt kvInt = new KVInt();
            kvInt.setId(id);
            kvInt.setValue(0L);
            if (response.containsKey(id)) {
                Map source = (Map)response.get(id);
                kvInt.setValue(((Number)source.getOrDefault(valueCName, 0)).longValue());
            }
            intValues.getValues().add(kvInt);
        }
        return intValues;
    }

    public Thermodynamic getThermodynamic(String indName, Downsampling downsampling, List<String> ids, String valueCName) throws IOException {
        String indexName = ModelName.build((Downsampling)downsampling, (String)indName);
        Thermodynamic thermodynamic = new Thermodynamic();
        ArrayList thermodynamicValueMatrix = new ArrayList();
        Map response = ((ElasticSearchClient)this.getClient()).ids(indexName, ids.toArray(new String[0]));
        int numOfSteps = 0;
        for (String id : ids) {
            Map source = (Map)response.get(id);
            if (source == null) {
                thermodynamicValueMatrix.add(new ArrayList());
                continue;
            }
            int axisYStep = ((Number)source.get("step")).intValue();
            thermodynamic.setAxisYStep(axisYStep);
            numOfSteps = ((Number)source.get("num_of_steps")).intValue() + 1;
            String value = (String)source.get("detail_group");
            IntKeyLongValueArray intKeyLongValues = new IntKeyLongValueArray(5);
            intKeyLongValues.toObject(value);
            ArrayList<Long> axisYValues = new ArrayList<Long>();
            for (int i = 0; i < numOfSteps; ++i) {
                axisYValues.add(0L);
            }
            for (IntKeyLongValue intKeyLongValue : intKeyLongValues) {
                axisYValues.set(intKeyLongValue.getKey(), intKeyLongValue.getValue());
            }
            thermodynamicValueMatrix.add(axisYValues);
        }
        thermodynamic.fromMatrixData(thermodynamicValueMatrix, numOfSteps);
        return thermodynamic;
    }
}

