/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.lock;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.register.worker.InventoryStreamProcessor;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterLockInstaller {
    private static final Logger logger = LoggerFactory.getLogger(RegisterLockInstaller.class);
    private final ElasticSearchClient client;

    public RegisterLockInstaller(ElasticSearchClient client) {
        this.client = client;
    }

    public void install() throws StorageException {
        boolean debug = System.getProperty("debug") != null;
        try {
            if (!this.client.isExistsIndex("register_lock")) {
                logger.info("table: {} does not exist", (Object)"register_lock");
                this.createIndex();
            } else if (debug) {
                logger.info("table: {} exists", (Object)"register_lock");
                this.deleteIndex();
                this.createIndex();
            }
            for (Class registerSource : InventoryStreamProcessor.getInstance().getAllRegisterSources()) {
                int scopeId = registerSource.getAnnotation(Stream.class).scopeId();
                this.putIfAbsent(scopeId);
            }
        }
        catch (IOException e) {
            throw new StorageException(e.getMessage());
        }
    }

    private void deleteIndex() throws IOException {
        this.client.deleteIndex("register_lock");
    }

    private void createIndex() throws IOException {
        JsonObject settings = new JsonObject();
        settings.addProperty("index.number_of_shards", (Number)1);
        settings.addProperty("index.number_of_replicas", (Number)0);
        settings.addProperty("index.refresh_interval", "1s");
        JsonObject mapping = new JsonObject();
        mapping.add("type", (JsonElement)new JsonObject());
        JsonObject type = mapping.get("type").getAsJsonObject();
        JsonObject properties = new JsonObject();
        type.add("properties", (JsonElement)properties);
        JsonObject column = new JsonObject();
        column.addProperty("type", "integer");
        properties.add("sequence", (JsonElement)column);
        this.client.createIndex("register_lock", settings, mapping);
    }

    private void putIfAbsent(int scopeId) throws IOException {
        GetResponse response = this.client.get("register_lock", String.valueOf(scopeId));
        if (!response.isExists()) {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
            builder.field("sequence", 1);
            builder.endObject();
            this.client.forceInsert("register_lock", String.valueOf(scopeId), builder);
        }
    }
}

