/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.lock;

import java.io.IOException;
import java.util.Map;
import org.apache.skywalking.oap.server.core.register.RegisterSource;
import org.apache.skywalking.oap.server.core.storage.IRegisterLockDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterLockDAOImpl
extends EsDAO
implements IRegisterLockDAO {
    private static final Logger logger = LoggerFactory.getLogger(RegisterLockDAOImpl.class);

    public RegisterLockDAOImpl(ElasticSearchClient client) {
        super(client);
    }

    public int getId(int scopeId, RegisterSource registerSource) {
        String id = scopeId + "";
        int sequence = 0;
        try {
            GetResponse response = ((ElasticSearchClient)this.getClient()).get("register_lock", id);
            if (response.isExists()) {
                Map source = response.getSource();
                sequence = ((Number)source.get("sequence")).intValue();
                long version = response.getVersion();
                this.lock(id, ++sequence, version);
            }
        }
        catch (Throwable t) {
            logger.warn("Try to lock the row with the id {} failure, error message: {}", (Object)id, (Object)t.getMessage());
            return 0;
        }
        return sequence;
    }

    private void lock(String id, int sequence, long version) throws IOException {
        XContentBuilder source = XContentFactory.jsonBuilder().startObject();
        source.field("sequence", sequence);
        source.endObject();
        ((ElasticSearchClient)this.getClient()).forceUpdate("register_lock", id, source, version);
    }
}

