/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.cache;

import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.oap.server.core.register.ServiceInventory;
import org.apache.skywalking.oap.server.core.storage.cache.IServiceInventoryCacheDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceInventoryCacheEsDAO
extends EsDAO
implements IServiceInventoryCacheDAO {
    private static final Logger logger = LoggerFactory.getLogger(ServiceInventoryCacheEsDAO.class);
    private final ServiceInventory.Builder builder = new ServiceInventory.Builder();

    public ServiceInventoryCacheEsDAO(ElasticSearchClient client) {
        super(client);
    }

    public int getServiceId(String serviceName) {
        String id = ServiceInventory.buildId((String)serviceName);
        return this.get(id);
    }

    public int getServiceId(int addressId) {
        String id = ServiceInventory.buildId((int)addressId);
        return this.get(id);
    }

    private int get(String id) {
        try {
            GetResponse response = ((ElasticSearchClient)this.getClient()).get("service_inventory", id);
            if (response.isExists()) {
                return response.getSource().getOrDefault("sequence", 0);
            }
            return 0;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return 0;
        }
    }

    public ServiceInventory get(int serviceId) {
        try {
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)"sequence", (int)serviceId));
            searchSourceBuilder.size(1);
            SearchResponse response = ((ElasticSearchClient)this.getClient()).search("service_inventory", searchSourceBuilder);
            if (response.getHits().totalHits == 1L) {
                SearchHit searchHit = response.getHits().getAt(0);
                return this.builder.map2Data(searchHit.getSourceAsMap());
            }
            return null;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return null;
        }
    }

    public List<ServiceInventory> loadLastMappingUpdate() {
        ArrayList<ServiceInventory> serviceInventories = new ArrayList<ServiceInventory>();
        try {
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
            boolQuery.must().add(QueryBuilders.termQuery((String)"is_address", (int)1));
            boolQuery.must().add(QueryBuilders.rangeQuery((String)"mapping_last_update_time").gte((Object)(System.currentTimeMillis() - 1800000L)));
            searchSourceBuilder.query((QueryBuilder)boolQuery);
            searchSourceBuilder.size(50);
            SearchResponse response = ((ElasticSearchClient)this.getClient()).search("service_inventory", searchSourceBuilder);
            for (SearchHit searchHit : response.getHits().getHits()) {
                serviceInventories.add(this.builder.map2Data(searchHit.getSourceAsMap()));
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
        return serviceInventories;
    }
}

