/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.cache;

import org.apache.skywalking.oap.server.core.register.ServiceInstanceInventory;
import org.apache.skywalking.oap.server.core.storage.cache.IServiceInstanceInventoryCacheDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceInstanceInventoryCacheDAO
extends EsDAO
implements IServiceInstanceInventoryCacheDAO {
    private static final Logger logger = LoggerFactory.getLogger(ServiceInstanceInventoryCacheDAO.class);
    private final ServiceInstanceInventory.Builder builder = new ServiceInstanceInventory.Builder();

    public ServiceInstanceInventoryCacheDAO(ElasticSearchClient client) {
        super(client);
    }

    public ServiceInstanceInventory get(int serviceInstanceId) {
        try {
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)"sequence", (int)serviceInstanceId));
            searchSourceBuilder.size(1);
            SearchResponse response = ((ElasticSearchClient)this.getClient()).search("service_instance_inventory", searchSourceBuilder);
            if (response.getHits().totalHits == 1L) {
                SearchHit searchHit = response.getHits().getAt(0);
                return this.builder.map2Data(searchHit.getSourceAsMap());
            }
            return null;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return null;
        }
    }

    public int getServiceInstanceId(int serviceId, String uuid) {
        String id = ServiceInstanceInventory.buildId((int)serviceId, (String)uuid);
        return this.get(id);
    }

    public int getServiceInstanceId(int serviceId, int addressId) {
        String id = ServiceInstanceInventory.buildId((int)serviceId, (int)addressId);
        return this.get(id);
    }

    private int get(String id) {
        try {
            GetResponse response = ((ElasticSearchClient)this.getClient()).get("service_instance_inventory", id);
            if (response.isExists()) {
                return response.getSource().getOrDefault("sequence", 0);
            }
            return 0;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return 0;
        }
    }
}

