/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.cache;

import org.apache.skywalking.oap.server.core.register.NetworkAddressInventory;
import org.apache.skywalking.oap.server.core.storage.cache.INetworkAddressInventoryCacheDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkAddressInventoryCacheEsDAO
extends EsDAO
implements INetworkAddressInventoryCacheDAO {
    private static final Logger logger = LoggerFactory.getLogger(NetworkAddressInventoryCacheEsDAO.class);
    private final NetworkAddressInventory.Builder builder = new NetworkAddressInventory.Builder();

    public NetworkAddressInventoryCacheEsDAO(ElasticSearchClient client) {
        super(client);
    }

    public int getAddressId(String networkAddress) {
        try {
            String id = NetworkAddressInventory.buildId((String)networkAddress);
            GetResponse response = ((ElasticSearchClient)this.getClient()).get("network_address_inventory", id);
            if (response.isExists()) {
                return response.getSource().getOrDefault("sequence", 0);
            }
            return 0;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return 0;
        }
    }

    public NetworkAddressInventory get(int addressId) {
        try {
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)"sequence", (int)addressId));
            searchSourceBuilder.size(1);
            SearchResponse response = ((ElasticSearchClient)this.getClient()).search("network_address_inventory", searchSourceBuilder);
            if (response.getHits().totalHits == 1L) {
                SearchHit searchHit = response.getHits().getAt(0);
                return this.builder.map2Data(searchHit.getSourceAsMap());
            }
            return null;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return null;
        }
    }
}

