/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.ModelColumn;
import org.apache.skywalking.oap.server.core.storage.model.ModelInstaller;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ColumnTypeEsMapping;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.MatchCNameBuilder;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.TimeSeriesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageEsInstaller
extends ModelInstaller {
    private static final Logger logger = LoggerFactory.getLogger(StorageEsInstaller.class);
    private final int indexShardsNumber;
    private final int indexReplicasNumber;
    private final ColumnTypeEsMapping columnTypeEsMapping;

    public StorageEsInstaller(ModuleManager moduleManager, int indexShardsNumber, int indexReplicasNumber) {
        super(moduleManager);
        this.indexShardsNumber = indexShardsNumber;
        this.indexReplicasNumber = indexReplicasNumber;
        this.columnTypeEsMapping = new ColumnTypeEsMapping();
    }

    protected boolean isExists(Client client, Model model) throws StorageException {
        ElasticSearchClient esClient = (ElasticSearchClient)client;
        try {
            if (model.isCapableOfTimeSeries()) {
                return esClient.isExistsTemplate(model.getName()) && esClient.isExistsIndex(model.getName());
            }
            return esClient.isExistsIndex(model.getName());
        }
        catch (IOException e) {
            throw new StorageException(e.getMessage());
        }
    }

    protected void createTable(Client client, Model model) throws StorageException {
        ElasticSearchClient esClient = (ElasticSearchClient)client;
        JsonObject settings = this.createSetting();
        JsonObject mapping = this.createMapping(model);
        logger.info("index {}'s columnTypeEsMapping builder str: {}", (Object)esClient.formatIndexName(model.getName()), (Object)mapping.toString());
        try {
            if (model.isCapableOfTimeSeries()) {
                if (!esClient.isExistsTemplate(model.getName())) {
                    boolean isAcknowledged = esClient.createTemplate(model.getName(), settings, mapping);
                    logger.info("create {} index template finished, isAcknowledged: {}", (Object)model.getName(), (Object)isAcknowledged);
                    if (!isAcknowledged) {
                        throw new StorageException("create " + model.getName() + " index template failure, ");
                    }
                }
                if (!esClient.isExistsIndex(model.getName())) {
                    String timeSeriesIndexName = TimeSeriesUtils.timeSeries(model);
                    boolean isAcknowledged = esClient.createIndex(timeSeriesIndexName);
                    logger.info("create {} index finished, isAcknowledged: {}", (Object)timeSeriesIndexName, (Object)isAcknowledged);
                    if (!isAcknowledged) {
                        throw new StorageException("create " + timeSeriesIndexName + " time series index failure, ");
                    }
                }
            } else {
                boolean isAcknowledged = esClient.createIndex(model.getName(), settings, mapping);
                logger.info("create {} index finished, isAcknowledged: {}", (Object)model.getName(), (Object)isAcknowledged);
                if (!isAcknowledged) {
                    throw new StorageException("create " + model.getName() + " index failure, ");
                }
            }
        }
        catch (IOException e) {
            throw new StorageException(e.getMessage());
        }
    }

    private JsonObject createSetting() {
        JsonObject setting = new JsonObject();
        setting.addProperty("index.number_of_shards", (Number)this.indexShardsNumber);
        setting.addProperty("index.number_of_replicas", (Number)this.indexReplicasNumber);
        setting.addProperty("index.refresh_interval", "3s");
        setting.addProperty("analysis.analyzer.oap_analyzer.type", "stop");
        return setting;
    }

    private JsonObject createMapping(Model model) {
        JsonObject mapping = new JsonObject();
        mapping.add("type", (JsonElement)new JsonObject());
        JsonObject type = mapping.get("type").getAsJsonObject();
        JsonObject properties = new JsonObject();
        type.add("properties", (JsonElement)properties);
        for (ModelColumn columnDefine : model.getColumns()) {
            JsonObject column;
            if (columnDefine.isMatchQuery()) {
                String matchCName = MatchCNameBuilder.INSTANCE.build(columnDefine.getColumnName().getName());
                JsonObject originalColumn = new JsonObject();
                originalColumn.addProperty("type", this.columnTypeEsMapping.transform(columnDefine.getType()));
                originalColumn.addProperty("copy_to", matchCName);
                properties.add(columnDefine.getColumnName().getName(), (JsonElement)originalColumn);
                JsonObject matchColumn = new JsonObject();
                matchColumn.addProperty("type", "text");
                matchColumn.addProperty("analyzer", "oap_analyzer");
                properties.add(matchCName, (JsonElement)matchColumn);
                continue;
            }
            if (columnDefine.isContent()) {
                column = new JsonObject();
                column.addProperty("type", "text");
                column.addProperty("index", Boolean.valueOf(false));
                properties.add(columnDefine.getColumnName().getName(), (JsonElement)column);
                continue;
            }
            column = new JsonObject();
            column.addProperty("type", this.columnTypeEsMapping.transform(columnDefine.getType()));
            properties.add(columnDefine.getColumnName().getName(), (JsonElement)column);
        }
        logger.debug("elasticsearch index template setting: {}", (Object)mapping.toString());
        return mapping;
    }
}

