/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base;

import java.io.IOException;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.storage.IRecordDAO;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.TimeSeriesUtils;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class RecordEsDAO
extends EsDAO
implements IRecordDAO<IndexRequest> {
    private final StorageBuilder<Record> storageBuilder;

    RecordEsDAO(ElasticSearchClient client, StorageBuilder<Record> storageBuilder) {
        super(client);
        this.storageBuilder = storageBuilder;
    }

    public IndexRequest prepareBatchInsert(Model model, Record record) throws IOException {
        XContentBuilder builder = this.map2builder(this.storageBuilder.data2Map((StorageData)record));
        String modelName = TimeSeriesUtils.timeSeries(model, record.getTimeBucket());
        return ((ElasticSearchClient)this.getClient()).prepareInsert(modelName, record.id(), builder);
    }
}

