/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base;

import java.io.IOException;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.storage.IMetricsDAO;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.TimeSeriesUtils;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class MetricsEsDAO
extends EsDAO
implements IMetricsDAO<IndexRequest, UpdateRequest> {
    private final StorageBuilder<Metrics> storageBuilder;

    MetricsEsDAO(ElasticSearchClient client, StorageBuilder<Metrics> storageBuilder) {
        super(client);
        this.storageBuilder = storageBuilder;
    }

    public Metrics get(Model model, Metrics metrics) throws IOException {
        SearchResponse response = ((ElasticSearchClient)this.getClient()).idQuery(model.getName(), metrics.id());
        if (response.getHits().totalHits > 0L) {
            return (Metrics)this.storageBuilder.map2Data(response.getHits().getAt(0).getSourceAsMap());
        }
        return null;
    }

    public IndexRequest prepareBatchInsert(Model model, Metrics metrics) throws IOException {
        XContentBuilder builder = this.map2builder(this.storageBuilder.data2Map((StorageData)metrics));
        String modelName = TimeSeriesUtils.timeSeries(model, metrics.getTimeBucket());
        return ((ElasticSearchClient)this.getClient()).prepareInsert(modelName, metrics.id(), builder);
    }

    public UpdateRequest prepareBatchUpdate(Model model, Metrics metrics) throws IOException {
        XContentBuilder builder = this.map2builder(this.storageBuilder.data2Map((StorageData)metrics));
        String modelName = TimeSeriesUtils.timeSeries(model, metrics.getTimeBucket());
        return ((ElasticSearchClient)this.getClient()).prepareUpdate(modelName, metrics.id(), builder);
    }
}

