/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.oap.server.core.config.ConfigService;
import org.apache.skywalking.oap.server.core.storage.IHistoryDeleteDAO;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.ttl.StorageTTL;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.TimeSeriesUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryDeleteEsDAO
extends EsDAO
implements IHistoryDeleteDAO {
    private static final Logger logger = LoggerFactory.getLogger(HistoryDeleteEsDAO.class);
    private final StorageTTL storageTTL;
    private final ModuleDefineHolder moduleDefineHolder;

    public HistoryDeleteEsDAO(ModuleDefineHolder moduleDefineHolder, ElasticSearchClient client, StorageTTL storageTTL) {
        super(client);
        this.moduleDefineHolder = moduleDefineHolder;
        this.storageTTL = storageTTL;
    }

    public void deleteHistory(Model model, String timeBucketColumnName) throws IOException {
        ConfigService configService = (ConfigService)this.moduleDefineHolder.find("core").provider().getService(ConfigService.class);
        ElasticSearchClient client = (ElasticSearchClient)this.getClient();
        long timeBefore = this.storageTTL.calculator(model.getDownsampling()).timeBefore(new DateTime(), configService.getDataTTLConfig());
        if (model.isCapableOfTimeSeries()) {
            List indexes = client.retrievalIndexByAliases(model.getName());
            ArrayList<String> prepareDeleteIndexes = new ArrayList<String>();
            for (String index : indexes) {
                long timeSeries = TimeSeriesUtils.indexTimeSeries(index);
                if (timeBefore < timeSeries) continue;
                prepareDeleteIndexes.add(index);
            }
            if (indexes.size() == prepareDeleteIndexes.size()) {
                client.createIndex(TimeSeriesUtils.timeSeries(model));
            }
            for (String prepareDeleteIndex : prepareDeleteIndexes) {
                client.deleteIndex(prepareDeleteIndex);
            }
        } else {
            int statusCode = client.delete(model.getName(), timeBucketColumnName, timeBefore);
            if (logger.isDebugEnabled()) {
                logger.debug("Delete history from {} index, status code {}", (Object)client.formatIndexName(model.getName()), (Object)statusCode);
            }
        }
    }
}

