/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base;

import java.util.List;
import org.apache.skywalking.oap.server.core.storage.IBatchDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchProcessEsDAO
extends EsDAO
implements IBatchDAO {
    private static final Logger logger = LoggerFactory.getLogger(BatchProcessEsDAO.class);
    private BulkProcessor bulkProcessor;
    private final int bulkActions;
    private final int bulkSize;
    private final int flushInterval;
    private final int concurrentRequests;

    public BatchProcessEsDAO(ElasticSearchClient client, int bulkActions, int bulkSize, int flushInterval, int concurrentRequests) {
        super(client);
        this.bulkActions = bulkActions;
        this.bulkSize = bulkSize;
        this.flushInterval = flushInterval;
        this.concurrentRequests = concurrentRequests;
    }

    public void batchPersistence(List<?> batchCollection) {
        if (this.bulkProcessor == null) {
            this.bulkProcessor = ((ElasticSearchClient)this.getClient()).createBulkProcessor(this.bulkActions, this.bulkSize, this.flushInterval, this.concurrentRequests);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("bulk data size: {}", (Object)batchCollection.size());
        }
        if (CollectionUtils.isNotEmpty(batchCollection)) {
            batchCollection.forEach(builder -> {
                if (builder instanceof IndexRequest) {
                    this.bulkProcessor.add((IndexRequest)builder);
                }
                if (builder instanceof UpdateRequest) {
                    this.bulkProcessor.add((DocWriteRequest)((UpdateRequest)builder));
                }
            });
        }
        this.bulkProcessor.flush();
    }
}

