/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.server.jetty;

import java.net.InetSocketAddress;
import java.util.Objects;
import javax.servlet.Servlet;
import org.apache.skywalking.oap.server.library.server.Server;
import org.apache.skywalking.oap.server.library.server.ServerException;
import org.apache.skywalking.oap.server.library.server.jetty.JettyHandler;
import org.apache.skywalking.oap.server.library.server.jetty.JettyServerException;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyServer
implements Server {
    private static final Logger logger = LoggerFactory.getLogger(JettyServer.class);
    private final String host;
    private final int port;
    private final String contextPath;
    private final int selectorNum;
    private org.eclipse.jetty.server.Server server;
    private ServletContextHandler servletContextHandler;

    public JettyServer(String host, int port, String contextPath) {
        this(host, port, contextPath, -1);
    }

    public JettyServer(String host, int port, String contextPath, int selectorNum) {
        this.host = host;
        this.port = port;
        this.contextPath = contextPath;
        this.selectorNum = selectorNum;
    }

    @Override
    public String hostPort() {
        return this.host + ":" + this.port;
    }

    @Override
    public String serverClassify() {
        return "Jetty";
    }

    @Override
    public void initialize() {
        this.server = new org.eclipse.jetty.server.Server(new InetSocketAddress(this.host, this.port));
        this.servletContextHandler = new ServletContextHandler(0);
        this.servletContextHandler.setContextPath(this.contextPath);
        logger.info("http server root context path: {}", (Object)this.contextPath);
        this.server.setHandler((Handler)this.servletContextHandler);
    }

    public void addHandler(JettyHandler handler) {
        logger.info("Bind handler {} into jetty server {}:{}", new Object[]{handler.getClass().getSimpleName(), this.host, this.port});
        ServletHolder servletHolder = new ServletHolder();
        servletHolder.setServlet((Servlet)handler);
        this.servletContextHandler.addServlet(servletHolder, handler.pathSpec());
    }

    @Override
    public boolean isSSLOpen() {
        return false;
    }

    @Override
    public boolean isStatusEqual(Server target) {
        return this.equals(target);
    }

    @Override
    public void start() throws ServerException {
        logger.info("start server, host: {}, port: {}", (Object)this.host, (Object)this.port);
        try {
            if (logger.isDebugEnabled() && this.servletContextHandler.getServletHandler() != null && this.servletContextHandler.getServletHandler().getServletMappings() != null) {
                for (ServletMapping servletMapping : this.servletContextHandler.getServletHandler().getServletMappings()) {
                    logger.debug("jetty servlet mappings: {} register by {}", (Object)servletMapping.getPathSpecs(), (Object)servletMapping.getServletName());
                }
            }
            this.server.start();
        }
        catch (Exception e) {
            throw new JettyServerException(e.getMessage(), e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JettyServer that = (JettyServer)o;
        return this.port == that.port && Objects.equals(this.host, that.host);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }
}

