/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spring.patch;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.StaticMethodsAroundInterceptor;

public class AopExpressionMatchInterceptor
implements StaticMethodsAroundInterceptor {
    private List<Method> methods = new ArrayList<Method>(2);

    public AopExpressionMatchInterceptor() {
        this.methods.addAll(Arrays.asList(EnhancedInstance.class.getDeclaredMethods()));
    }

    public void beforeMethod(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, MethodInterceptResult result) {
    }

    public Object afterMethod(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, Object ret) {
        Method targetAopMethod = (Method)allArguments[1];
        Class targetAopClass = (Class)allArguments[2];
        if (targetAopClass != null && EnhancedInstance.class.isAssignableFrom(targetAopClass) && this.isEnhancedMethod(targetAopMethod)) {
            return false;
        }
        return ret;
    }

    public void handleMethodException(Class clazz, Method method, Object[] allArguments, Class<?>[] parameterTypes, Throwable t) {
    }

    private boolean isEnhancedMethod(Method targetMethod) {
        for (Method method : this.methods) {
            if (!method.getName().equals(targetMethod.getName()) || !method.getReturnType().equals(targetMethod.getReturnType()) || !this.equalParamTypes(method.getParameterTypes(), targetMethod.getParameterTypes())) continue;
            return true;
        }
        return false;
    }

    private boolean equalParamTypes(Class<?>[] params1, Class<?>[] params2) {
        if (params1.length != params2.length) {
            return false;
        }
        for (int i = 0; i < params1.length; ++i) {
            if (params1[i].equals(params2[i])) continue;
            return false;
        }
        return true;
    }
}

