/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.clr.provider.handler;

import java.util.Objects;
import org.apache.skywalking.apm.network.common.CPU;
import org.apache.skywalking.apm.network.language.agent.CLRMetric;
import org.apache.skywalking.apm.network.language.agent.ClrGC;
import org.apache.skywalking.apm.network.language.agent.ClrThread;
import org.apache.skywalking.oap.server.core.cache.ServiceInstanceInventoryCache;
import org.apache.skywalking.oap.server.core.register.ServiceInstanceInventory;
import org.apache.skywalking.oap.server.core.source.ServiceInstanceCLRCPU;
import org.apache.skywalking.oap.server.core.source.ServiceInstanceCLRGC;
import org.apache.skywalking.oap.server.core.source.ServiceInstanceCLRThread;
import org.apache.skywalking.oap.server.core.source.Source;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CLRSourceDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(CLRSourceDispatcher.class);
    private final SourceReceiver sourceReceiver;
    private final ServiceInstanceInventoryCache instanceInventoryCache;

    public CLRSourceDispatcher(ModuleManager moduleManager) {
        this.sourceReceiver = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
        this.instanceInventoryCache = (ServiceInstanceInventoryCache)moduleManager.find("core").provider().getService(ServiceInstanceInventoryCache.class);
    }

    void sendMetric(int serviceInstanceId, long minuteTimeBucket, CLRMetric metrics) {
        ServiceInstanceInventory serviceInstanceInventory = this.instanceInventoryCache.get(serviceInstanceId);
        if (!Objects.nonNull(serviceInstanceInventory)) {
            logger.warn("Can't found service by service instance id from cache, service instance id is: {}", (Object)serviceInstanceId);
            return;
        }
        int serviceId = serviceInstanceInventory.getServiceId();
        CPU cpu = metrics.getCpu();
        ServiceInstanceCLRCPU serviceInstanceCLRCPU = new ServiceInstanceCLRCPU();
        serviceInstanceCLRCPU.setUsePercent(cpu.getUsagePercent());
        serviceInstanceCLRCPU.setTimeBucket(minuteTimeBucket);
        serviceInstanceCLRCPU.setId(serviceInstanceId);
        serviceInstanceCLRCPU.setName("");
        serviceInstanceCLRCPU.setServiceId(serviceId);
        serviceInstanceCLRCPU.setServiceName("");
        this.sourceReceiver.receive((Source)serviceInstanceCLRCPU);
        ClrGC gc = metrics.getGc();
        ServiceInstanceCLRGC serviceInstanceCLRGC = new ServiceInstanceCLRGC();
        serviceInstanceCLRGC.setGen0CollectCount(gc.getGen0CollectCount());
        serviceInstanceCLRGC.setGen1CollectCount(gc.getGen1CollectCount());
        serviceInstanceCLRGC.setGen2CollectCount(gc.getGen2CollectCount());
        serviceInstanceCLRGC.setHeapMemory(gc.getHeapMemory());
        serviceInstanceCLRGC.setTimeBucket(minuteTimeBucket);
        serviceInstanceCLRGC.setId(serviceInstanceId);
        serviceInstanceCLRGC.setName("");
        serviceInstanceCLRGC.setServiceId(serviceId);
        serviceInstanceCLRGC.setServiceName("");
        this.sourceReceiver.receive((Source)serviceInstanceCLRGC);
        ClrThread thread = metrics.getThread();
        ServiceInstanceCLRThread serviceInstanceCLRThread = new ServiceInstanceCLRThread();
        serviceInstanceCLRThread.setAvailableCompletionPortThreads((long)thread.getAvailableCompletionPortThreads());
        serviceInstanceCLRThread.setAvailableWorkerThreads((long)thread.getAvailableWorkerThreads());
        serviceInstanceCLRThread.setMaxCompletionPortThreads((long)thread.getMaxCompletionPortThreads());
        serviceInstanceCLRThread.setMaxWorkerThreads((long)thread.getMaxWorkerThreads());
        serviceInstanceCLRThread.setTimeBucket(minuteTimeBucket);
        serviceInstanceCLRThread.setId(serviceInstanceId);
        serviceInstanceCLRThread.setName("");
        serviceInstanceCLRThread.setServiceId(serviceId);
        serviceInstanceCLRThread.setServiceName("");
        this.sourceReceiver.receive((Source)serviceInstanceCLRThread);
    }
}

