/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.clr.provider.handler;

import io.grpc.stub.StreamObserver;
import org.apache.skywalking.apm.network.common.Commands;
import org.apache.skywalking.apm.network.language.agent.CLRMetric;
import org.apache.skywalking.apm.network.language.agent.v2.CLRMetricCollection;
import org.apache.skywalking.apm.network.language.agent.v2.CLRMetricReportServiceGrpc;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCHandler;
import org.apache.skywalking.oap.server.receiver.clr.provider.handler.CLRSourceDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CLRMetricReportServiceHandler
extends CLRMetricReportServiceGrpc.CLRMetricReportServiceImplBase
implements GRPCHandler {
    private static final Logger logger = LoggerFactory.getLogger(CLRMetricReportServiceHandler.class);
    private final CLRSourceDispatcher clrSourceDispatcher;

    public CLRMetricReportServiceHandler(ModuleManager moduleManager) {
        this.clrSourceDispatcher = new CLRSourceDispatcher(moduleManager);
    }

    public void collect(CLRMetricCollection request, StreamObserver<Commands> responseObserver) {
        int serviceInstanceId = request.getServiceInstanceId();
        if (logger.isDebugEnabled()) {
            logger.debug("receive the clr metrics from service instance, id: {}", (Object)serviceInstanceId);
        }
        request.getMetricsList().forEach(metrics -> {
            long minuteTimeBucket = TimeBucket.getMinuteTimeBucket((long)metrics.getTime());
            this.clrSourceDispatcher.sendMetric(serviceInstanceId, minuteTimeBucket, (CLRMetric)metrics);
        });
        responseObserver.onNext((Object)Commands.newBuilder().build());
        responseObserver.onCompleted();
    }
}

