/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.util;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.skywalking.apm.util.ConfigDesc;
import org.apache.skywalking.apm.util.StringUtil;

public class ConfigInitializer {
    private static final Logger logger = Logger.getLogger(ConfigInitializer.class.getName());

    public static void initialize(Properties properties, Class<?> rootConfigType) throws IllegalAccessException {
        ConfigInitializer.initNextLevel(properties, rootConfigType, new ConfigDesc());
    }

    private static void initNextLevel(Properties properties, Class<?> recentConfigType, ConfigDesc parentDesc) throws IllegalArgumentException, IllegalAccessException {
        for (Field field : recentConfigType.getFields()) {
            String configKey;
            String value;
            if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || (value = properties.getProperty(configKey = (parentDesc + "." + field.getName()).toLowerCase())) == null) continue;
            Class<?> type = field.getType();
            if (type.equals(Integer.TYPE)) {
                field.set(null, Integer.valueOf(value));
                continue;
            }
            if (type.equals(String.class)) {
                field.set(null, value);
                continue;
            }
            if (type.equals(Long.TYPE)) {
                field.set(null, Long.valueOf(value));
                continue;
            }
            if (type.equals(Boolean.TYPE)) {
                field.set(null, Boolean.valueOf(value));
                continue;
            }
            if (type.equals(List.class)) {
                field.set(null, ConfigInitializer.convert2List(value));
                continue;
            }
            if (!type.isEnum()) continue;
            field.set(null, Enum.valueOf(type, value.toUpperCase()));
        }
        for (AnnotatedElement annotatedElement : recentConfigType.getClasses()) {
            parentDesc.append(((Class)annotatedElement).getSimpleName());
            ConfigInitializer.initNextLevel(properties, annotatedElement, parentDesc);
            parentDesc.removeLastDesc();
        }
    }

    private static List convert2List(String value) {
        String[] segments;
        LinkedList<String> result = new LinkedList<String>();
        if (StringUtil.isEmpty(value)) {
            return result;
        }
        for (String segment : segments = value.split(",")) {
            String trimmedSegment = segment.trim();
            if (StringUtil.isEmpty(trimmedSegment)) continue;
            result.add(trimmedSegment);
        }
        return result;
    }
}

