/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.sofarpc;

import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class SofaRpcProviderInterceptor
implements InstanceMethodsAroundInterceptor {
    public static final String SKYWALKING_PREFIX = "skywalking.";

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        SofaRequest sofaRequest = (SofaRequest)allArguments[0];
        AbstractSpan span = null;
        ContextCarrier contextCarrier = new ContextCarrier();
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            String headKey = next.getHeadKey();
            Object attachment = sofaRequest.getRequestProp(SKYWALKING_PREFIX + headKey);
            if (attachment != null) {
                next.setHeadValue(attachment.toString());
                continue;
            }
            next.setHeadValue("");
        }
        span = ContextManager.createEntrySpan((String)this.generateViewPoint(sofaRequest), (ContextCarrier)contextCarrier);
        span.setComponent((Component)ComponentsDefine.SOFARPC);
        SpanLayer.asRPCFramework((AbstractSpan)span);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        SofaResponse result = (SofaResponse)ret;
        if (result != null && result.isError()) {
            this.dealException((Throwable)result.getAppResponse());
        }
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        this.dealException(t);
    }

    private void dealException(Throwable throwable) {
        AbstractSpan span = ContextManager.activeSpan();
        span.errorOccurred();
        span.log(throwable);
    }

    private String generateViewPoint(SofaRequest sofaRequest) {
        StringBuilder operationName = new StringBuilder();
        operationName.append(sofaRequest.getInterfaceName());
        operationName.append("." + sofaRequest.getMethodName() + "(");
        for (String arg : sofaRequest.getMethodArgSigs()) {
            operationName.append(arg + ",");
        }
        if (sofaRequest.getMethodArgs().length > 0) {
            operationName.delete(operationName.length() - 1, operationName.length());
        }
        operationName.append(")");
        return operationName.toString();
    }
}

