/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.sofarpc;

import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class SofaRpcConsumerInterceptor
implements InstanceMethodsAroundInterceptor {
    public static final String SKYWALKING_PREFIX = "skywalking.";

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        SofaRequest sofaRequest = (SofaRequest)allArguments[0];
        RpcInternalContext rpcContext = RpcInternalContext.getContext();
        ProviderInfo providerInfo = rpcContext.getProviderInfo();
        AbstractSpan span = null;
        String host = providerInfo.getHost();
        int port = providerInfo.getPort();
        ContextCarrier contextCarrier = new ContextCarrier();
        String operationName = this.generateOperationName(providerInfo, sofaRequest);
        span = ContextManager.createExitSpan((String)operationName, (ContextCarrier)contextCarrier, (String)(host + ":" + port));
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            String key = next.getHeadKey();
            String skyWalkingKey = SKYWALKING_PREFIX + key;
            sofaRequest.addRequestProp(skyWalkingKey, (Object)next.getHeadValue());
        }
        Tags.URL.set(span, this.generateRequestURL(providerInfo, sofaRequest));
        span.setComponent((Component)ComponentsDefine.SOFARPC);
        SpanLayer.asRPCFramework((AbstractSpan)span);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        SofaResponse result = (SofaResponse)ret;
        if (result != null && result.isError()) {
            this.dealException((Throwable)result.getAppResponse());
        }
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        this.dealException(t);
    }

    private void dealException(Throwable throwable) {
        AbstractSpan span = ContextManager.activeSpan();
        span.errorOccurred();
        span.log(throwable);
    }

    private String generateOperationName(ProviderInfo providerInfo, SofaRequest sofaRequest) {
        StringBuilder operationName = new StringBuilder();
        operationName.append(sofaRequest.getInterfaceName());
        operationName.append("." + sofaRequest.getMethodName() + "(");
        for (String arg : sofaRequest.getMethodArgSigs()) {
            operationName.append(arg + ",");
        }
        if (sofaRequest.getMethodArgs().length > 0) {
            operationName.delete(operationName.length() - 1, operationName.length());
        }
        operationName.append(")");
        return operationName.toString();
    }

    private String generateRequestURL(ProviderInfo providerInfo, SofaRequest sofaRequest) {
        StringBuilder requestURL = new StringBuilder();
        requestURL.append(providerInfo.getProtocolType() + "://");
        requestURL.append(providerInfo.getHost());
        requestURL.append(":" + providerInfo.getPort() + "/");
        requestURL.append(this.generateOperationName(providerInfo, sofaRequest));
        return requestURL.toString();
    }
}

