/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.buffer;

import org.apache.skywalking.apm.util.StringUtil;

class Offset {
    private static final String SPLIT_CHARACTER = ",";
    private final ReadOffset readOffset;
    private final WriteOffset writeOffset = new WriteOffset();

    Offset() {
        this.readOffset = new ReadOffset(this.writeOffset);
    }

    String serialize() {
        return this.readOffset.getFileName() + SPLIT_CHARACTER + String.valueOf(this.readOffset.getOffset()) + SPLIT_CHARACTER + this.writeOffset.getFileName() + SPLIT_CHARACTER + String.valueOf(this.writeOffset.getOffset());
    }

    void deserialize(String value) {
        String[] values;
        if (!StringUtil.isEmpty((String)value) && (values = value.split(SPLIT_CHARACTER)).length == 4) {
            this.readOffset.setFileName(values[0]);
            this.readOffset.setOffset(Long.parseLong(values[1]));
            this.writeOffset.setFileName(values[2]);
            this.writeOffset.setOffset(Long.parseLong(values[3]));
        }
    }

    public ReadOffset getReadOffset() {
        return this.readOffset;
    }

    public WriteOffset getWriteOffset() {
        return this.writeOffset;
    }

    static class WriteOffset {
        private String fileName;
        private long offset = 0L;

        WriteOffset() {
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public long getOffset() {
            return this.offset;
        }

        public void setOffset(long offset) {
            this.offset = offset;
        }
    }

    static class ReadOffset {
        private String fileName;
        private long offset = 0L;
        private final WriteOffset writeOffset;

        private ReadOffset(WriteOffset writeOffset) {
            this.writeOffset = writeOffset;
        }

        boolean isCurrentWriteFile() {
            return this.fileName.equals(this.writeOffset.fileName);
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public long getOffset() {
            return this.offset;
        }

        public void setOffset(long offset) {
            this.offset = offset;
        }
    }
}

