/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.buffer;

import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.GeneratedMessageV3;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.library.buffer.BufferFileUtils;
import org.apache.skywalking.oap.server.library.buffer.Offset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataStreamWriter<MESSAGE_TYPE extends GeneratedMessageV3> {
    private static final Logger logger = LoggerFactory.getLogger(DataStreamWriter.class);
    private final File directory;
    private final Offset.WriteOffset writeOffset;
    private final int dataFileMaxSize;
    private boolean initialized = false;
    private FileOutputStream outputStream;

    DataStreamWriter(File directory, Offset.WriteOffset writeOffset, int dataFileMaxSize) {
        this.directory = directory;
        this.dataFileMaxSize = dataFileMaxSize;
        this.writeOffset = writeOffset;
    }

    synchronized void initialize() throws IOException {
        if (!this.initialized) {
            File writingFile;
            String writeFileName = this.writeOffset.getFileName();
            if (StringUtil.isEmpty((String)writeFileName)) {
                writingFile = this.createNewFile();
            } else {
                writingFile = new File(this.directory, writeFileName);
                if (!writingFile.exists()) {
                    writingFile = this.createNewFile();
                }
            }
            this.outputStream = FileUtils.openOutputStream((File)writingFile, (boolean)true);
            this.initialized = true;
        }
    }

    private File createNewFile() throws IOException {
        String fileName = BufferFileUtils.buildFileName("data");
        File writingFile = new File(this.directory, fileName);
        boolean created = writingFile.createNewFile();
        if (!created) {
            logger.info("The file named {} already exists.", (Object)writingFile.getAbsolutePath());
        } else {
            logger.info("Create a new buffer data file: {}", (Object)writingFile.getAbsolutePath());
        }
        this.writeOffset.setOffset(0L);
        this.writeOffset.setFileName(writingFile.getName());
        return writingFile;
    }

    synchronized void write(AbstractMessageLite messageLite) {
        try {
            messageLite.writeDelimitedTo((OutputStream)this.outputStream);
            long position = this.outputStream.getChannel().position();
            this.writeOffset.setOffset(position);
            if (position >= 0x100000L * (long)this.dataFileMaxSize) {
                File writingFile = this.createNewFile();
                this.outputStream.close();
                this.outputStream = FileUtils.openOutputStream((File)writingFile, (boolean)true);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

