/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.buffer;

import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Parser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.skywalking.apm.util.RunnableWithExceptionProtection;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.library.buffer.BufferData;
import org.apache.skywalking.oap.server.library.buffer.BufferDataCollection;
import org.apache.skywalking.oap.server.library.buffer.BufferFileUtils;
import org.apache.skywalking.oap.server.library.buffer.Offset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStreamReader<MESSAGE_TYPE extends GeneratedMessageV3> {
    private static final Logger logger = LoggerFactory.getLogger(DataStreamReader.class);
    private final File directory;
    private final Offset.ReadOffset readOffset;
    private final Parser<MESSAGE_TYPE> parser;
    private final CallBack<MESSAGE_TYPE> callBack;
    private final int collectionSize = 100;
    private final BufferDataCollection<MESSAGE_TYPE> bufferDataCollection;
    private File readingFile;
    private InputStream inputStream;

    DataStreamReader(File directory, Offset.ReadOffset readOffset, Parser<MESSAGE_TYPE> parser, CallBack<MESSAGE_TYPE> callBack) {
        this.directory = directory;
        this.readOffset = readOffset;
        this.parser = parser;
        this.callBack = callBack;
        this.bufferDataCollection = new BufferDataCollection(100);
    }

    void initialize() {
        this.preRead();
        Executors.newSingleThreadScheduledExecutor().scheduleWithFixedDelay((Runnable)new RunnableWithExceptionProtection(this::read, t -> logger.error("Buffer data pre read failure.", t)), 3L, 1L, TimeUnit.SECONDS);
    }

    private void preRead() {
        String fileName = this.readOffset.getFileName();
        if (StringUtil.isEmpty((String)fileName)) {
            this.openInputStream(this.readEarliestDataFile());
        } else {
            File readingFile = new File(this.directory, fileName);
            if (readingFile.exists()) {
                this.openInputStream(readingFile);
                try {
                    this.inputStream.skip(this.readOffset.getOffset());
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            } else {
                this.openInputStream(this.readEarliestDataFile());
            }
        }
    }

    private void openInputStream(File readingFile) {
        try {
            this.readingFile = readingFile;
            if (Objects.nonNull(this.inputStream)) {
                this.inputStream.close();
            }
            this.inputStream = new FileInputStream(readingFile);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private File readEarliestDataFile() {
        String[] fileNames = this.directory.list((FilenameFilter)new PrefixFileFilter("data"));
        if (fileNames != null && fileNames.length > 0) {
            BufferFileUtils.sort(fileNames);
            this.readOffset.setFileName(fileNames[0]);
            this.readOffset.setOffset(0L);
            return new File(this.directory, fileNames[0]);
        }
        return null;
    }

    private void read() {
        if (logger.isDebugEnabled()) {
            logger.debug("Read buffer data");
        }
        try {
            if (this.readOffset.getOffset() == this.readingFile.length() && !this.readOffset.isCurrentWriteFile()) {
                FileUtils.forceDelete((File)this.readingFile);
                this.openInputStream(this.readEarliestDataFile());
            }
            while (this.readOffset.getOffset() < this.readingFile.length()) {
                BufferData<GeneratedMessageV3> bufferData = new BufferData<GeneratedMessageV3>((GeneratedMessageV3)this.parser.parseDelimitedFrom(this.inputStream));
                if (bufferData.getMessageType() != null) {
                    boolean isComplete = this.callBack.call(bufferData);
                    int serialized = bufferData.getMessageType().getSerializedSize();
                    int offset = CodedOutputStream.computeUInt32SizeNoTag((int)serialized) + serialized;
                    this.readOffset.setOffset(this.readOffset.getOffset() + (long)offset);
                    if (!isComplete) {
                        if (this.bufferDataCollection.size() == 100) {
                            this.reCall();
                        }
                        this.bufferDataCollection.add(bufferData);
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("collection size: {}, max size: {}", (Object)this.bufferDataCollection.size(), (Object)100);
                    continue;
                }
                if (this.bufferDataCollection.size() > 0) {
                    this.reCall();
                    continue;
                }
                try {
                    TimeUnit.SECONDS.sleep(5L);
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void reCall() {
        int maxCycle = 10;
        for (int i = 1; i <= maxCycle && this.bufferDataCollection.size() > 0; ++i) {
            List<BufferData<MESSAGE_TYPE>> bufferDataList = this.bufferDataCollection.export();
            for (BufferData<MESSAGE_TYPE> data : bufferDataList) {
                if (this.callBack.call(data) || i == maxCycle) continue;
                this.bufferDataCollection.add(data);
            }
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static interface CallBack<MESSAGE_TYPE extends GeneratedMessageV3> {
        public boolean call(BufferData<MESSAGE_TYPE> var1);
    }
}

