/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.buffer;

import com.google.protobuf.GeneratedMessageV3;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.skywalking.oap.server.library.buffer.BufferData;

public class BufferDataCollection<MESSAGE_TYPE extends GeneratedMessageV3> {
    private AtomicInteger index = new AtomicInteger(0);
    private final List<BufferData<MESSAGE_TYPE>> bufferDataList;

    public BufferDataCollection(int size) {
        this.bufferDataList = new ArrayList<BufferData<MESSAGE_TYPE>>(size);
        for (int i = 0; i < size; ++i) {
            this.bufferDataList.add(null);
        }
    }

    public void add(BufferData<MESSAGE_TYPE> bufferData) {
        this.bufferDataList.set(this.index.getAndIncrement(), bufferData);
    }

    public int size() {
        return this.index.get();
    }

    public synchronized List<BufferData<MESSAGE_TYPE>> export() {
        ArrayList<BufferData<MESSAGE_TYPE>> exportData = new ArrayList<BufferData<MESSAGE_TYPE>>(this.index.get());
        for (int i = 0; i < this.index.get(); ++i) {
            exportData.add(this.bufferDataList.get(i));
        }
        this.index.set(0);
        return exportData;
    }
}

