/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.starter;

import org.apache.skywalking.oap.server.core.RunningMode;
import org.apache.skywalking.oap.server.library.module.ApplicationConfiguration;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.starter.config.ApplicationConfigLoader;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAPServerStartUp {
    private static final Logger logger = LoggerFactory.getLogger(OAPServerStartUp.class);

    public static void main(String[] args) {
        String mode = System.getProperty("mode");
        RunningMode.setMode((String)mode);
        ApplicationConfigLoader configLoader = new ApplicationConfigLoader();
        ModuleManager manager = new ModuleManager();
        try {
            ApplicationConfiguration applicationConfiguration = configLoader.load();
            manager.init(applicationConfiguration);
            ((MetricsCreator)manager.find("telemetry").provider().getService(MetricsCreator.class)).createGauge("uptime", "oap server start up time", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE).setValue((double)System.currentTimeMillis() / 1000.0);
            if (RunningMode.isInitMode()) {
                logger.info("OAP starts up in init mode successfully, exit now...");
                System.exit(0);
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            System.exit(1);
        }
    }
}

