/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.zipkin.trace;

import java.util.List;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.cache.EndpointInventoryCache;
import org.apache.skywalking.oap.server.core.cache.ServiceInventoryCache;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.source.Source;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.util.BooleanUtils;
import org.apache.skywalking.oap.server.receiver.sharing.server.CoreRegisterLinker;
import org.apache.skywalking.oap.server.receiver.zipkin.ZipkinReceiverConfig;
import org.apache.skywalking.oap.server.storage.plugin.zipkin.ZipkinSpan;
import zipkin2.Span;
import zipkin2.codec.SpanBytesEncoder;

public class SpanForward {
    private ZipkinReceiverConfig config;
    private SourceReceiver receiver;
    private ServiceInventoryCache serviceInventoryCache;
    private EndpointInventoryCache endpointInventoryCache;
    private int encode;

    public SpanForward(ZipkinReceiverConfig config, SourceReceiver receiver, ServiceInventoryCache serviceInventoryCache, EndpointInventoryCache endpointInventoryCache, int encode) {
        this.config = config;
        this.receiver = receiver;
        this.serviceInventoryCache = serviceInventoryCache;
        this.endpointInventoryCache = endpointInventoryCache;
        this.encode = encode;
    }

    public void send(List<Span> spanList) {
        spanList.forEach(span -> {
            ZipkinSpan zipkinSpan = new ZipkinSpan();
            zipkinSpan.setTraceId(span.traceId());
            zipkinSpan.setSpanId(span.id());
            String serviceName = span.localServiceName();
            int serviceId = 0;
            if (!StringUtil.isEmpty((String)serviceName)) {
                serviceId = this.serviceInventoryCache.getServiceId(serviceName);
                if (serviceId != 0) {
                    zipkinSpan.setServiceId(serviceId);
                } else {
                    CoreRegisterLinker.getServiceInventoryRegister().getOrCreate(serviceName, null);
                }
            }
            String spanName = span.name();
            Span.Kind kind = span.kind();
            switch (kind) {
                case SERVER: 
                case CONSUMER: {
                    if (StringUtil.isEmpty((String)spanName) || serviceId == 0) break;
                    int endpointId = this.endpointInventoryCache.getEndpointId(serviceId, spanName, DetectPoint.SERVER.ordinal());
                    if (endpointId != 0) {
                        zipkinSpan.setEndpointId(endpointId);
                        break;
                    }
                    if (!this.config.isRegisterZipkinEndpoint()) break;
                    CoreRegisterLinker.getEndpointInventoryRegister().getOrCreate(serviceId, spanName, DetectPoint.SERVER);
                }
            }
            if (!StringUtil.isEmpty((String)spanName)) {
                zipkinSpan.setEndpointName(spanName);
            }
            long startTime = span.timestampAsLong() / 1000L;
            zipkinSpan.setStartTime(startTime);
            if (startTime != 0L) {
                long timeBucket = TimeBucket.getSecondTimeBucket((long)zipkinSpan.getStartTime());
                zipkinSpan.setTimeBucket(timeBucket);
            }
            long latency = span.durationAsLong() / 1000L;
            zipkinSpan.setEndTime(startTime + latency);
            zipkinSpan.setIsError(BooleanUtils.booleanToValue((Boolean)false));
            zipkinSpan.setEncode(1);
            zipkinSpan.setLatency((int)latency);
            zipkinSpan.setDataBinary(SpanBytesEncoder.PROTO3.encode(span));
            this.receiver.receive((Source)zipkinSpan);
        });
    }
}

