/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.zipkin.handler;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.skywalking.oap.server.core.cache.EndpointInventoryCache;
import org.apache.skywalking.oap.server.core.cache.ServiceInventoryCache;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.server.jetty.JettyHandler;
import org.apache.skywalking.oap.server.receiver.zipkin.ZipkinReceiverConfig;
import org.apache.skywalking.oap.server.receiver.zipkin.handler.SpanEncode;
import org.apache.skywalking.oap.server.receiver.zipkin.handler.SpanProcessor;
import org.apache.skywalking.oap.server.receiver.zipkin.handler.SpanV2JettyHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zipkin2.codec.SpanBytesDecoder;

public class SpanV1JettyHandler
extends JettyHandler {
    private static final Logger logger = LoggerFactory.getLogger(SpanV2JettyHandler.class);
    private ZipkinReceiverConfig config;
    private SourceReceiver sourceReceiver;
    private ServiceInventoryCache serviceInventoryCache;
    private EndpointInventoryCache endpointInventoryCache;

    public SpanV1JettyHandler(ZipkinReceiverConfig config, ModuleManager manager) {
        this.sourceReceiver = (SourceReceiver)manager.find("core").provider().getService(SourceReceiver.class);
        this.serviceInventoryCache = (ServiceInventoryCache)manager.find("core").provider().getService(ServiceInventoryCache.class);
        this.endpointInventoryCache = (EndpointInventoryCache)manager.find("core").provider().getService(EndpointInventoryCache.class);
        this.config = config;
    }

    public String pathSpec() {
        return "/api/v1/spans";
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        try {
            String type = request.getHeader("Content-Type");
            int encode = type != null && type.contains("/x-thrift") ? 3 : 4;
            SpanBytesDecoder decoder = SpanEncode.isThrift(encode) ? SpanBytesDecoder.THRIFT : SpanBytesDecoder.JSON_V1;
            SpanProcessor processor = new SpanProcessor(this.sourceReceiver, this.serviceInventoryCache, this.endpointInventoryCache, encode);
            processor.convert(this.config, decoder, request);
            response.setStatus(202);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

