/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.zipkin.handler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.skywalking.oap.server.core.cache.EndpointInventoryCache;
import org.apache.skywalking.oap.server.core.cache.ServiceInventoryCache;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.receiver.zipkin.ZipkinReceiverConfig;
import org.apache.skywalking.oap.server.receiver.zipkin.analysis.ZipkinSkyWalkingTransfer;
import org.apache.skywalking.oap.server.receiver.zipkin.trace.SpanForward;
import zipkin2.codec.SpanBytesDecoder;

public class SpanProcessor {
    private SourceReceiver receiver;
    private ServiceInventoryCache serviceInventoryCache;
    private EndpointInventoryCache endpointInventoryCache;
    private int encode;

    public SpanProcessor(SourceReceiver receiver, ServiceInventoryCache serviceInventoryCache, EndpointInventoryCache endpointInventoryCache, int encode) {
        this.receiver = receiver;
        this.serviceInventoryCache = serviceInventoryCache;
        this.endpointInventoryCache = endpointInventoryCache;
        this.encode = encode;
    }

    void convert(ZipkinReceiverConfig config, SpanBytesDecoder decoder, HttpServletRequest request) throws IOException {
        int readCntOnce;
        InputStream inputStream = this.getInputStream(request);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        while ((readCntOnce = inputStream.read(buffer)) >= 0) {
            out.write(buffer, 0, readCntOnce);
        }
        List spanList = decoder.decodeList(out.toByteArray());
        if (config.isNeedAnalysis()) {
            ZipkinSkyWalkingTransfer transfer = new ZipkinSkyWalkingTransfer();
            transfer.doTransfer(config, spanList);
        } else {
            SpanForward forward = new SpanForward(config, this.receiver, this.serviceInventoryCache, this.endpointInventoryCache, this.encode);
            forward.send(spanList);
        }
    }

    private InputStream getInputStream(HttpServletRequest request) throws IOException {
        String headEncoding = request.getHeader("accept-encoding");
        Object requestInStream = headEncoding != null && headEncoding.indexOf("gzip") != -1 ? new GZIPInputStream((InputStream)request.getInputStream()) : request.getInputStream();
        return requestInStream;
    }
}

