/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.zipkin.analysis.transform;

import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.oap.server.receiver.zipkin.analysis.data.SkyWalkingTrace;
import org.apache.skywalking.oap.server.receiver.zipkin.analysis.data.ZipkinTrace;
import org.apache.skywalking.oap.server.receiver.zipkin.analysis.transform.SegmentBuilder;
import org.apache.skywalking.oap.server.receiver.zipkin.analysis.transform.SegmentListener;
import zipkin2.Span;

public class Zipkin2SkyWalkingTransfer {
    public static Zipkin2SkyWalkingTransfer INSTANCE = new Zipkin2SkyWalkingTransfer();
    private List<SegmentListener> listeners = new LinkedList<SegmentListener>();

    private Zipkin2SkyWalkingTransfer() {
    }

    public void addListener(SegmentListener listener) {
        this.listeners.add(listener);
    }

    public void transfer(ZipkinTrace trace) throws Exception {
        List<Span> traceSpans = trace.getSpans();
        if (traceSpans.size() > 0) {
            SkyWalkingTrace skyWalkingTrace = SegmentBuilder.build(traceSpans);
            this.listeners.forEach(listener -> listener.notify(skyWalkingTrace));
        }
    }
}

