/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.zipkin.analysis.transform;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.skywalking.apm.network.common.KeyStringValuePair;
import org.apache.skywalking.apm.network.language.agent.RefType;
import org.apache.skywalking.apm.network.language.agent.SpanType;
import org.apache.skywalking.apm.network.language.agent.UniqueId;
import org.apache.skywalking.apm.network.language.agent.v2.Log;
import org.apache.skywalking.apm.network.language.agent.v2.SegmentObject;
import org.apache.skywalking.apm.network.language.agent.v2.SegmentReference;
import org.apache.skywalking.apm.network.language.agent.v2.SpanObjectV2;
import org.apache.skywalking.oap.server.receiver.sharing.server.CoreRegisterLinker;
import org.apache.skywalking.oap.server.receiver.zipkin.analysis.ZipkinTraceOSInfoBuilder;
import org.apache.skywalking.oap.server.receiver.zipkin.analysis.data.SkyWalkingTrace;
import org.eclipse.jetty.util.StringUtil;
import zipkin2.Endpoint;
import zipkin2.Span;

public class SegmentBuilder {
    private Context context;
    private LinkedList<Segment> segments = new LinkedList();
    private Map<String, ClientSideSpan> clientPartSpan;

    private SegmentBuilder() {
        this.context = new Context();
        this.clientPartSpan = new HashMap<String, ClientSideSpan>();
    }

    public static SkyWalkingTrace build(List<Span> traceSpans) throws Exception {
        String applicationCode;
        SegmentBuilder builder = new SegmentBuilder();
        HashMap<String, List<Span>> childSpanMap = new HashMap<String, List<Span>>();
        AtomicReference root = new AtomicReference();
        traceSpans.forEach(span -> {
            LinkedList<Span> spanList;
            if (span.parentId() == null) {
                root.set(span);
            }
            if ((spanList = (LinkedList<Span>)childSpanMap.get(span.parentId())) == null) {
                spanList = new LinkedList<Span>();
                spanList.add((Span)span);
                childSpanMap.put(span.parentId(), spanList);
            } else {
                spanList.add((Span)span);
            }
        });
        Span rootSpan = (Span)root.get();
        long timestamp = 0L;
        if (rootSpan != null && !Strings.isNullOrEmpty((String)(applicationCode = rootSpan.localServiceName()))) {
            timestamp = rootSpan.timestampAsLong();
            builder.context.addApp(applicationCode, rootSpan.timestampAsLong() / 1000L);
            SpanObjectV2.Builder rootSpanBuilder = builder.initSpan(null, null, rootSpan, true);
            builder.context.currentSegment().addSpan(rootSpanBuilder);
            builder.scanSpansFromRoot(rootSpanBuilder, rootSpan, childSpanMap);
            builder.segments.add(builder.context.removeApp());
        }
        LinkedList<SegmentObject.Builder> segmentBuilders = new LinkedList<SegmentObject.Builder>();
        long finalTimestamp = timestamp / 1000L;
        builder.segments.forEach(segment -> {
            SegmentObject.Builder traceSegmentBuilder = segment.freeze();
            segmentBuilders.add(traceSegmentBuilder);
            CoreRegisterLinker.getServiceInventoryRegister().heartbeat(traceSegmentBuilder.getServiceId(), finalTimestamp);
            CoreRegisterLinker.getServiceInstanceInventoryRegister().heartbeat(traceSegmentBuilder.getServiceInstanceId(), finalTimestamp);
        });
        return new SkyWalkingTrace(builder.generateTraceOrSegmentId(), segmentBuilders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanSpansFromRoot(SpanObjectV2.Builder parentSegmentSpan, Span parent, Map<String, List<Span>> childSpanMap) throws Exception {
        String parentId = parent.id();
        List<Span> spanList = childSpanMap.get(parentId);
        if (spanList == null) {
            return;
        }
        for (Span childSpan : spanList) {
            String localServiceName = childSpan.localServiceName();
            boolean isNewApp = false;
            if (StringUtil.isNotBlank((String)localServiceName) && this.context.isAppChanged(localServiceName)) {
                isNewApp = true;
            }
            try {
                if (isNewApp) {
                    this.context.addApp(localServiceName, childSpan.timestampAsLong() / 1000L);
                }
                SpanObjectV2.Builder childSpanBuilder = this.initSpan(parentSegmentSpan, parent, childSpan, isNewApp);
                this.context.currentSegment().addSpan(childSpanBuilder);
                this.scanSpansFromRoot(childSpanBuilder, childSpan, childSpanMap);
            }
            finally {
                if (!isNewApp) continue;
                this.segments.add(this.context.removeApp());
            }
        }
    }

    private SpanObjectV2.Builder initSpan(SpanObjectV2.Builder parentSegmentSpan, Span parentSpan, Span span, boolean isSegmentRoot) {
        SpanObjectV2.Builder spanBuilder = SpanObjectV2.newBuilder();
        spanBuilder.setSpanId(this.context.currentIDs().nextSpanId());
        if (isSegmentRoot) {
            spanBuilder.setParentSpanId(-1);
        }
        if (!isSegmentRoot && parentSegmentSpan != null) {
            spanBuilder.setParentSpanId(parentSegmentSpan.getSpanId());
        }
        Span.Kind kind = span.kind();
        String opName = Strings.isNullOrEmpty((String)span.name()) ? "-" : span.name();
        spanBuilder.setOperationName(opName);
        switch (kind) {
            case CLIENT: {
                spanBuilder.setSpanType(SpanType.Exit);
                String peer = this.getPeer(parentSpan, span);
                if (peer != null) {
                    spanBuilder.setPeer(peer);
                }
                ClientSideSpan clientSideSpan = new ClientSideSpan(span, spanBuilder);
                this.clientPartSpan.put(span.id(), clientSideSpan);
                break;
            }
            case SERVER: {
                spanBuilder.setSpanType(SpanType.Entry);
                this.buildRef(spanBuilder, span, parentSegmentSpan, parentSpan);
                break;
            }
            case CONSUMER: {
                spanBuilder.setSpanType(SpanType.Entry);
                this.buildRef(spanBuilder, span, parentSegmentSpan, parentSpan);
                break;
            }
            case PRODUCER: {
                spanBuilder.setSpanType(SpanType.Exit);
                String peer = this.getPeer(parentSpan, span);
                if (peer != null) {
                    spanBuilder.setPeer(peer);
                }
                ClientSideSpan clientSideSpan = new ClientSideSpan(span, spanBuilder);
                this.clientPartSpan.put(span.id(), clientSideSpan);
                break;
            }
            default: {
                spanBuilder.setSpanType(SpanType.Local);
            }
        }
        long startTime = span.timestamp() / 1000L;
        Long durationObj = span.duration();
        long duration = durationObj == null ? 0L : durationObj / 1000L;
        spanBuilder.setStartTime(startTime);
        spanBuilder.setEndTime(startTime + duration);
        span.tags().forEach((tagKey, tagValue) -> spanBuilder.addTags(KeyStringValuePair.newBuilder().setKey(tagKey).setValue(tagValue).build()));
        span.annotations().forEach(annotation -> spanBuilder.addLogs(Log.newBuilder().setTime(annotation.timestamp() / 1000L).addData(KeyStringValuePair.newBuilder().setKey("zipkin.annotation").setValue(annotation.value()).build())));
        return spanBuilder;
    }

    private void buildRef(SpanObjectV2.Builder spanBuilder, Span span, SpanObjectV2.Builder parentSegmentSpan, Span parentSpan) {
        String peer;
        ClientSideSpan clientSideSpan;
        Segment parentSegment = this.context.parentSegment();
        if (parentSegment == null) {
            return;
        }
        Segment rootSegment = this.context.rootSegment();
        if (rootSegment == null) {
            return;
        }
        if (span.shared() != null && span.shared().booleanValue() && (clientSideSpan = this.clientPartSpan.get(span.id())) != null) {
            parentSegmentSpan = clientSideSpan.getBuilder();
            parentSpan = clientSideSpan.getSpan();
        }
        if (StringUtil.isBlank((String)(peer = this.getPeer(parentSpan, span)))) {
            return;
        }
        SegmentReference.Builder refBuilder = SegmentReference.newBuilder();
        refBuilder.setEntryServiceInstanceId(rootSegment.builder().getServiceInstanceId());
        int endpointId = rootSegment.getEntryEndpointId();
        if (endpointId == 0) {
            refBuilder.setEntryEndpoint(rootSegment.getEntryEndpointName());
        } else {
            refBuilder.setEntryEndpointId(endpointId);
        }
        refBuilder.setEntryServiceInstanceId(rootSegment.builder().getServiceInstanceId());
        refBuilder.setNetworkAddress(peer);
        parentSegmentSpan.setPeer(refBuilder.getNetworkAddress());
        refBuilder.setParentServiceInstanceId(parentSegment.builder().getServiceInstanceId());
        refBuilder.setParentSpanId(parentSegmentSpan.getSpanId());
        refBuilder.setParentTraceSegmentId(parentSegment.builder().getTraceSegmentId());
        int parentEndpointId = parentSegment.getEntryEndpointId();
        if (parentEndpointId == 0) {
            refBuilder.setParentEndpoint(parentSegment.getEntryEndpointName());
        } else {
            refBuilder.setParentEndpointId(parentEndpointId);
        }
        refBuilder.setRefType(RefType.CrossProcess);
        spanBuilder.addRefs(refBuilder);
    }

    private String getPeer(Span parentSpan, Span childSpan) {
        Endpoint serverEndpoint = childSpan == null ? null : childSpan.localEndpoint();
        String peer = this.endpoint2Peer(serverEndpoint);
        if (peer == null) {
            Endpoint clientEndpoint = parentSpan == null ? null : parentSpan.remoteEndpoint();
            peer = this.endpoint2Peer(clientEndpoint);
        }
        return peer;
    }

    private String endpoint2Peer(Endpoint endpoint) {
        String ip = null;
        Integer port = 0;
        if (endpoint != null) {
            if (!Strings.isNullOrEmpty((String)endpoint.ipv4())) {
                ip = endpoint.ipv4();
                port = endpoint.port();
            } else if (!Strings.isNullOrEmpty((String)endpoint.ipv6())) {
                ip = endpoint.ipv6();
                port = endpoint.port();
            }
        }
        if (ip == null) {
            return null;
        }
        return port == null || port == 0 ? ip : ip + ":" + port;
    }

    private UniqueId generateTraceOrSegmentId() {
        return UniqueId.newBuilder().addIdParts(ThreadLocalRandom.current().nextLong()).addIdParts(ThreadLocalRandom.current().nextLong()).addIdParts(ThreadLocalRandom.current().nextLong()).build();
    }

    private class ClientSideSpan {
        private Span span;
        private SpanObjectV2.Builder builder;

        public ClientSideSpan(Span span, SpanObjectV2.Builder builder) {
            this.span = span;
            this.builder = builder;
        }

        public Span getSpan() {
            return this.span;
        }

        public SpanObjectV2.Builder getBuilder() {
            return this.builder;
        }
    }

    private class IDCollection {
        private String applicationCode;
        private int appId;
        private int instanceId;
        private int spanIdSeq;

        private IDCollection(String applicationCode, int appId, int instanceId) {
            this.applicationCode = applicationCode;
            this.appId = appId;
            this.instanceId = instanceId;
            this.spanIdSeq = 0;
        }

        private int nextSpanId() {
            return this.spanIdSeq++;
        }
    }

    private class Segment {
        private SegmentObject.Builder segmentBuilder;
        private IDCollection ids;
        private int entryEndpointId = 0;
        private String entryEndpointName = null;
        private List<SpanObjectV2.Builder> spans;
        private long endTime = 0L;

        private Segment(String serviceCode, int serviceId, int serviceInstanceId) {
            this.ids = new IDCollection(serviceCode, serviceId, serviceInstanceId);
            this.spans = new LinkedList<SpanObjectV2.Builder>();
            this.segmentBuilder = SegmentObject.newBuilder();
            this.segmentBuilder.setServiceId(serviceId);
            this.segmentBuilder.setServiceInstanceId(serviceInstanceId);
            this.segmentBuilder.setTraceSegmentId(SegmentBuilder.this.generateTraceOrSegmentId());
        }

        private SegmentObject.Builder builder() {
            return this.segmentBuilder;
        }

        private void addSpan(SpanObjectV2.Builder spanBuilder) {
            String operationName = spanBuilder.getOperationName();
            if (this.entryEndpointId == 0 && !Strings.isNullOrEmpty((String)operationName) && SpanType.Entry == spanBuilder.getSpanType()) {
                if (!Strings.isNullOrEmpty((String)operationName)) {
                    this.entryEndpointName = operationName;
                } else {
                    this.entryEndpointId = spanBuilder.getOperationNameId();
                }
            }
            if (spanBuilder.getSpanId() == 1 && this.entryEndpointId == 0) {
                if (!Strings.isNullOrEmpty((String)operationName)) {
                    this.entryEndpointName = operationName;
                } else {
                    this.entryEndpointId = spanBuilder.getOperationNameId();
                }
            }
            this.spans.add(spanBuilder);
            if (spanBuilder.getEndTime() > this.endTime) {
                this.endTime = spanBuilder.getEndTime();
            }
        }

        public int getEntryEndpointId() {
            return this.entryEndpointId;
        }

        public String getEntryEndpointName() {
            return this.entryEndpointName;
        }

        private IDCollection ids() {
            return this.ids;
        }

        public SegmentObject.Builder freeze() {
            for (SpanObjectV2.Builder span : this.spans) {
                this.segmentBuilder.addSpans(span);
            }
            return this.segmentBuilder;
        }

        public long getEndTime() {
            return this.endTime;
        }
    }

    private class Context {
        private LinkedList<Segment> segmentsStack = new LinkedList();

        private Context() {
        }

        private boolean isAppChanged(String applicationCode) {
            return !Strings.isNullOrEmpty((String)applicationCode) && !applicationCode.equals(this.currentIDs().applicationCode);
        }

        private Segment addApp(String serviceCode, long registerTime) throws Exception {
            int serviceId = this.waitForExchange(() -> CoreRegisterLinker.getServiceInventoryRegister().getOrCreate(serviceCode, null), 10);
            int serviceInstanceId = this.waitForExchange(() -> CoreRegisterLinker.getServiceInstanceInventoryRegister().getOrCreate(serviceId, serviceCode, serviceCode, registerTime, ZipkinTraceOSInfoBuilder.getOSInfoForZipkin(serviceCode)), 10);
            Segment segment = new Segment(serviceCode, serviceId, serviceInstanceId);
            this.segmentsStack.add(segment);
            return segment;
        }

        private IDCollection currentIDs() {
            return this.segmentsStack.getLast().ids;
        }

        private Segment currentSegment() {
            return this.segmentsStack.getLast();
        }

        private Segment parentSegment() {
            if (this.segmentsStack.size() < 2) {
                return null;
            }
            return this.segmentsStack.get(this.segmentsStack.size() - 2);
        }

        private Segment rootSegment() {
            if (this.segmentsStack.size() < 2) {
                return null;
            }
            return this.segmentsStack.getFirst();
        }

        private Segment removeApp() {
            return this.segmentsStack.removeLast();
        }

        private int waitForExchange(Callable<Integer> callable, int retry) throws Exception {
            for (int i = 0; i < retry; ++i) {
                Integer id = callable.call();
                if (id != 0) {
                    return id;
                }
                Thread.sleep(1000L);
            }
            throw new TimeoutException("ID exchange costs more than expected.");
        }
    }
}

