/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.zipkin.analysis.data;

import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.apm.network.language.agent.UniqueId;
import org.apache.skywalking.apm.network.language.agent.UpstreamSegment;
import org.apache.skywalking.apm.network.language.agent.v2.SegmentObject;

public class SkyWalkingTrace {
    private UniqueId globalTraceId;
    private List<SegmentObject.Builder> segmentList;

    public SkyWalkingTrace(UniqueId globalTraceId, List<SegmentObject.Builder> segmentList) {
        this.globalTraceId = globalTraceId;
        this.segmentList = segmentList;
    }

    public List<UpstreamSegment.Builder> toUpstreamSegment() {
        LinkedList<UpstreamSegment.Builder> newUpstreamList = new LinkedList<UpstreamSegment.Builder>();
        this.segmentList.forEach(segment -> {
            UpstreamSegment.Builder builder = UpstreamSegment.newBuilder();
            builder.addGlobalTraceIds(this.globalTraceId);
            builder.setSegment(segment.build().toByteString());
            newUpstreamList.add(builder);
        });
        return newUpstreamList;
    }

    public UniqueId getGlobalTraceId() {
        return this.globalTraceId;
    }

    public List<SegmentObject.Builder> getSegmentList() {
        return this.segmentList;
    }
}

