/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.zipkin.analysis.cache.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.skywalking.oap.server.receiver.zipkin.ZipkinReceiverConfig;
import org.apache.skywalking.oap.server.receiver.zipkin.analysis.cache.ISpanCache;
import org.apache.skywalking.oap.server.receiver.zipkin.analysis.data.ZipkinTrace;
import org.apache.skywalking.oap.server.receiver.zipkin.analysis.transform.Zipkin2SkyWalkingTransfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zipkin2.Span;

public class CaffeineSpanCache
implements ISpanCache,
RemovalListener<String, ZipkinTrace> {
    private static final Logger logger = LoggerFactory.getLogger(CaffeineSpanCache.class);
    private Cache<String, ZipkinTrace> inProcessSpanCache;
    private ReentrantLock newTraceLock = new ReentrantLock();

    public CaffeineSpanCache(ZipkinReceiverConfig config) {
        this.inProcessSpanCache = Caffeine.newBuilder().expireAfterWrite((long)config.getExpireTime(), TimeUnit.SECONDS).maximumSize((long)config.getMaxCacheSize()).removalListener((RemovalListener)this).build();
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> this.inProcessSpanCache.put((Object)"ACTIVE", (Object)new ZipkinTrace.TriggerTrace()), 2L, 3L, TimeUnit.SECONDS);
    }

    public void onRemoval(@Nullable String key, @Nullable ZipkinTrace trace, @Nonnull RemovalCause cause) {
        if (trace instanceof ZipkinTrace.TriggerTrace) {
            return;
        }
        try {
            Zipkin2SkyWalkingTransfer.INSTANCE.transfer(trace);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            logger.warn("Zipkin trace:" + trace);
        }
    }

    @Override
    public void addSpan(Span span) {
        ZipkinTrace trace = (ZipkinTrace)this.inProcessSpanCache.getIfPresent((Object)span.traceId());
        if (trace == null) {
            this.newTraceLock.lock();
            try {
                trace = (ZipkinTrace)this.inProcessSpanCache.getIfPresent((Object)span.traceId());
                if (trace == null) {
                    trace = new ZipkinTrace();
                    this.inProcessSpanCache.put((Object)span.traceId(), (Object)trace);
                }
            }
            finally {
                this.newTraceLock.unlock();
            }
        }
        trace.addSpan(span);
    }
}

