/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.zipkin;

import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.server.ServerException;
import org.apache.skywalking.oap.server.library.server.jetty.JettyHandler;
import org.apache.skywalking.oap.server.library.server.jetty.JettyServer;
import org.apache.skywalking.oap.server.receiver.sharing.server.CoreRegisterLinker;
import org.apache.skywalking.oap.server.receiver.trace.provider.parser.ISegmentParserService;
import org.apache.skywalking.oap.server.receiver.zipkin.ZipkinReceiverConfig;
import org.apache.skywalking.oap.server.receiver.zipkin.ZipkinReceiverModule;
import org.apache.skywalking.oap.server.receiver.zipkin.analysis.Receiver2AnalysisBridge;
import org.apache.skywalking.oap.server.receiver.zipkin.analysis.transform.Zipkin2SkyWalkingTransfer;
import org.apache.skywalking.oap.server.receiver.zipkin.handler.SpanV1JettyHandler;
import org.apache.skywalking.oap.server.receiver.zipkin.handler.SpanV2JettyHandler;

public class ZipkinReceiverProvider
extends ModuleProvider {
    public static final String NAME = "default";
    private ZipkinReceiverConfig config = new ZipkinReceiverConfig();
    private JettyServer jettyServer;

    public String name() {
        return NAME;
    }

    public Class<? extends ModuleDefine> module() {
        return ZipkinReceiverModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.config;
    }

    public void prepare() throws ServiceNotProvidedException {
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        CoreRegisterLinker.setModuleManager((ModuleManager)this.getManager());
        this.jettyServer = new JettyServer(this.config.getHost(), this.config.getPort(), this.config.getContextPath());
        this.jettyServer.initialize();
        this.jettyServer.addHandler((JettyHandler)new SpanV1JettyHandler(this.config, this.getManager()));
        this.jettyServer.addHandler((JettyHandler)new SpanV2JettyHandler(this.config, this.getManager()));
        if (this.config.isNeedAnalysis()) {
            ISegmentParserService segmentParseService = (ISegmentParserService)this.getManager().find("receiver-trace").provider().getService(ISegmentParserService.class);
            Receiver2AnalysisBridge bridge = new Receiver2AnalysisBridge(segmentParseService);
            Zipkin2SkyWalkingTransfer.INSTANCE.addListener(bridge);
        }
    }

    public void notifyAfterCompleted() throws ModuleStartException {
        try {
            this.jettyServer.start();
        }
        catch (ServerException e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
    }

    public String[] requiredModules() {
        if (this.config.isNeedAnalysis()) {
            return new String[]{"receiver-trace"};
        }
        return new String[]{"core"};
    }
}

