/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.customize.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;

public class CustomizeExpression {
    private static final ILog logger = LogManager.getLogger(CustomizeExpression.class);

    public static Map<String, Object> evaluationContext(Object[] allArguments) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        for (int i = 0; i < allArguments.length; ++i) {
            context.put("arg[" + i + "]", allArguments[i]);
        }
        return context;
    }

    public static String parseExpression(String expression, Map<String, Object> context) {
        try {
            String[] es = expression.split("\\.");
            Object o = context.get(es[0]);
            return o == null ? "null" : String.valueOf(CustomizeExpression.parse(es, o, 0));
        }
        catch (Exception e) {
            logger.debug("parse expression error, expression is {}, exception is {}", new Object[]{expression, e.getMessage()});
            return "null";
        }
    }

    private static Object parse(String[] expressions, Object o, int i) {
        int next = i + 1;
        if (next == expressions.length) {
            return o;
        }
        return (o = CustomizeExpression.parse0(expressions[next], o)) == null ? "null" : CustomizeExpression.parse(expressions, o, next);
    }

    private static Object parse0(String expression, Object o) {
        if (o instanceof Map) {
            return CustomizeExpression.matcherMap(expression, o);
        }
        if (o instanceof List) {
            return CustomizeExpression.matcherList(expression, o);
        }
        if (o.getClass().isArray()) {
            return CustomizeExpression.matcherArray(expression, o);
        }
        return CustomizeExpression.matcherDefault(expression, o);
    }

    private static Object matcherMap(String expression, Object o) {
        String key = expression.replace("['", "").replace("']", "");
        return ((Map)o).get(key);
    }

    private static Object matcherList(String expression, Object o) {
        int index = Integer.valueOf(expression.replace("[", "").replace("]", ""));
        List l = (List)o;
        return l != null && l.size() > index ? l.get(index) : null;
    }

    private static Object matcherArray(String expression, Object o) {
        int index = Integer.valueOf(expression.replace("[", "").replace("]", ""));
        return o != null && Array.getLength(o) > index ? Array.get(o, index) : null;
    }

    private static Object matcherDefault(String expression, Object o) {
        try {
            if (expression.contains("()")) {
                Method m = o.getClass().getMethod(expression.replace("()", ""), null);
                return m.invoke(o, null);
            }
            Field f = o.getClass().getDeclaredField(expression);
            f.setAccessible(true);
            return f.get(o);
        }
        catch (Exception e) {
            logger.debug("matcher default error, expression is {}, object is {}, expression is {}", new Object[]{expression, o, e.getMessage()});
            return null;
        }
    }
}

