/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.customize.interceptor;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.plugin.customize.conf.CustomizeConfiguration;
import org.apache.skywalking.apm.plugin.customize.conf.MethodConfiguration;
import org.apache.skywalking.apm.plugin.customize.util.CustomizeExpression;

class BaseInterceptorMethods {
    BaseInterceptorMethods() {
    }

    void beforeMethod(Method method, Object[] allArguments) {
        Map<String, Object> configuration = CustomizeConfiguration.INSTANCE.getConfiguration(method);
        if (!MethodConfiguration.isCloseBeforeMethod(configuration)) {
            String operationName = MethodConfiguration.getOperationName(configuration);
            Map<String, Object> context = CustomizeExpression.evaluationContext(allArguments);
            if (context == null || context.isEmpty()) {
                ContextManager.createLocalSpan((String)operationName);
            } else {
                String expression;
                Map<String, String> tags = MethodConfiguration.getTags(configuration);
                HashMap<String, String> spanTags = new HashMap<String, String>();
                Map<String, String> logs = MethodConfiguration.getLogs(configuration);
                HashMap<String, String> spanLogs = new HashMap<String, String>();
                List<String> operationNameSuffixes = MethodConfiguration.getOperationNameSuffixes(configuration);
                StringBuilder operationNameSuffix = new StringBuilder();
                if (operationNameSuffixes != null && !operationNameSuffixes.isEmpty()) {
                    for (String expression2 : operationNameSuffixes) {
                        operationNameSuffix.append("/");
                        operationNameSuffix.append(CustomizeExpression.parseExpression(expression2, context));
                    }
                }
                if (tags != null && !tags.isEmpty()) {
                    for (String key : tags.keySet()) {
                        expression = tags.get(key);
                        spanTags.put(key, CustomizeExpression.parseExpression(expression, context));
                    }
                }
                if (logs != null && !logs.isEmpty()) {
                    for (String key : logs.keySet()) {
                        expression = logs.get(key);
                        spanLogs.put(key, CustomizeExpression.parseExpression(expression, context));
                    }
                }
                operationName = operationNameSuffix.insert(0, operationName).toString();
                AbstractSpan span = ContextManager.createLocalSpan((String)operationName);
                if (!spanTags.isEmpty()) {
                    for (Map.Entry tag : spanTags.entrySet()) {
                        span.tag((String)tag.getKey(), (String)tag.getValue());
                    }
                }
                if (!spanLogs.isEmpty()) {
                    span.log(System.currentTimeMillis(), spanLogs);
                }
            }
        }
    }

    void afterMethod(Method method) {
        if (!MethodConfiguration.isCloseAfterMethod(CustomizeConfiguration.INSTANCE.getConfiguration(method))) {
            ContextManager.stopSpan();
        }
    }

    void handleMethodException(Throwable t) {
        if (ContextManager.activeSpan() != null) {
            ContextManager.activeSpan().errorOccurred().log(t);
        }
    }
}

