/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.customize.conf;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.plugin.bytebuddy.ArgumentTypeNameMatch;
import org.apache.skywalking.apm.agent.core.util.MethodUtil;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.matcher.ElementMatcher;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.matcher.ElementMatchers;
import org.apache.skywalking.apm.plugin.customize.conf.MethodConfiguration;
import org.apache.skywalking.apm.plugin.customize.util.CustomizeUtil;
import org.apache.skywalking.apm.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public enum CustomizeConfiguration {
    INSTANCE;

    private static final ILog logger;

    public void load() {
        try {
            this.parse(this.resolver());
        }
        catch (Exception e) {
            logger.error("CustomizeConfiguration load fail", (Throwable)e);
        }
    }

    private List<Map<String, Object>> resolver() throws ParserConfigurationException, IOException, SAXException {
        ArrayList<Map<String, Object>> customizeMethods = new ArrayList<Map<String, Object>>();
        File file = new File(Config.Plugin.Customize.ENHANCE_FILE);
        if (file.exists() && file.isFile()) {
            NodeList classNodeList = this.resolverFileClassDesc(file);
            this.resolverClassNodeList(classNodeList, customizeMethods);
        }
        return customizeMethods;
    }

    private NodeList resolverFileClassDesc(File file) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(file);
        return doc.getElementsByTagName("class");
    }

    private void resolverClassNodeList(NodeList classNodeList, List<Map<String, Object>> customizeMethods) {
        for (int ec = 0; ec < classNodeList.getLength(); ++ec) {
            Node classDesc = classNodeList.item(ec);
            NodeList methodNodeList = classDesc.getChildNodes();
            for (int ms = 0; ms < methodNodeList.getLength(); ++ms) {
                String className;
                Map<String, Object> configuration;
                Node methodDesc = methodNodeList.item(ms);
                if (methodDesc.getNodeType() != 1 || (configuration = this.resolverMethodNodeDesc(className = classDesc.getAttributes().getNamedItem("class_name").getNodeValue(), methodDesc)) == null) continue;
                customizeMethods.add(configuration);
            }
        }
    }

    private Map<String, Object> resolverMethodNodeDesc(String className, Node methodDesc) {
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        if (methodDesc.getAttributes().getNamedItem("operation_name") != null) {
            MethodConfiguration.setOperationName(configuration, methodDesc.getAttributes().getNamedItem("operation_name").getNodeValue());
        }
        if (methodDesc.getAttributes().getNamedItem("close_before_method") != null) {
            MethodConfiguration.setCloseBeforeMethod(configuration, Boolean.valueOf(methodDesc.getAttributes().getNamedItem("close_before_method").getNodeValue()));
        } else {
            MethodConfiguration.setCloseBeforeMethod(configuration, false);
        }
        if (methodDesc.getAttributes().getNamedItem("close_after_method") != null) {
            MethodConfiguration.setCloseAfterMethod(configuration, Boolean.valueOf(methodDesc.getAttributes().getNamedItem("close_after_method").getNodeValue()));
        } else {
            MethodConfiguration.setCloseAfterMethod(configuration, false);
        }
        if (methodDesc.getAttributes().getNamedItem("static") != null) {
            MethodConfiguration.setStatic(configuration, Boolean.valueOf(methodDesc.getAttributes().getNamedItem("static").getNodeValue()));
        }
        this.setAdvancedField(configuration, methodDesc);
        return this.resolverClassAndMethod(className, methodDesc.getAttributes().getNamedItem("method").getNodeValue(), configuration);
    }

    private void setAdvancedField(Map<String, Object> configuration, Node methodNode) {
        NodeList methodContents = methodNode.getChildNodes();
        for (int mc = 0; mc < methodContents.getLength(); ++mc) {
            Node methodContentNode = methodContents.item(mc);
            if (methodContentNode.getNodeType() != 1) continue;
            if ("operation_name_suffix".equals(methodContentNode.getNodeName())) {
                MethodConfiguration.addOperationNameSuffixes(configuration, methodContentNode.getTextContent());
            }
            if ("tag".equals(methodContentNode.getNodeName())) {
                MethodConfiguration.addTag(configuration, methodContentNode.getAttributes().getNamedItem("key").getNodeValue(), methodContentNode.getTextContent());
            }
            if (!"log".equals(methodContentNode.getNodeName())) continue;
            MethodConfiguration.addLog(configuration, methodContentNode.getAttributes().getNamedItem("key").getNodeValue(), methodContentNode.getTextContent());
        }
    }

    private Map<String, Object> resolverClassAndMethod(String className, String methodDesc, Map<String, Object> configuration) {
        try {
            int openParen = methodDesc.indexOf("(");
            int closeParen = methodDesc.indexOf(")");
            String methodName = methodDesc.substring(0, openParen);
            String[] arguments = methodDesc.substring(openParen + 1, closeParen).split(",");
            MethodConfiguration.setClz(configuration, className);
            MethodConfiguration.setMethod(configuration, CustomizeUtil.generateOperationName(className, methodName, arguments));
            MethodConfiguration.setMethodName(configuration, methodName);
            MethodConfiguration.setArguments(configuration, StringUtil.isEmpty((String)arguments[0]) ? new String[]{} : arguments);
            if (StringUtil.isEmpty((String)MethodConfiguration.getOperationName(configuration))) {
                MethodConfiguration.setOperationName(configuration, MethodConfiguration.getMethod(configuration));
            }
            return configuration;
        }
        catch (Exception e) {
            logger.error((Throwable)e, "Failed to resolver, className is {}, methodDesc is {}.", new Object[]{className, methodDesc});
            return null;
        }
    }

    private void parse(List<Map<String, Object>> configurations) {
        this.init();
        for (Map<String, Object> configuration : configurations) {
            this.addContextMethodConfiguration(configuration);
            this.addContextEnhanceClass(configuration);
        }
    }

    private void init() {
        Config.Plugin.Customize.CONTEXT.put("CONTEXT_METHOD_CONFIGURATIONS", new HashMap());
        Config.Plugin.Customize.CONTEXT.put("CONTEXT_ENHANCE_CLASSES", new HashMap());
    }

    private void addContextMethodConfiguration(Map<String, Object> configuration) {
        this.getMethodConfigurations().put(MethodConfiguration.getMethod(configuration), configuration);
    }

    private Map<String, Map<String, Object>> getMethodConfigurations() {
        return (Map)Config.Plugin.Customize.CONTEXT.get("CONTEXT_METHOD_CONFIGURATIONS");
    }

    private void addContextEnhanceClass(Map<String, Object> configuration) {
        HashMap<String, ElementMatcher> enhanceClasses;
        String key = CustomizeUtil.generateClassDesc(MethodConfiguration.getClz(configuration), MethodConfiguration.isStatic(configuration));
        ElementMatcher matcher = (enhanceClasses = this.getEnhanceClasses()).get(key);
        enhanceClasses.put(key, (ElementMatcher)(matcher == null ? this.parserMethodsMatcher(configuration) : ((ElementMatcher.Junction)matcher).or(this.parserMethodsMatcher(configuration))));
    }

    private ElementMatcher parserMethodsMatcher(Map<String, Object> configuration) {
        String[] arguments = MethodConfiguration.getArguments(configuration);
        ElementMatcher.Junction matcher = ElementMatchers.named((String)MethodConfiguration.getMethodName(configuration)).and((ElementMatcher)ElementMatchers.takesArguments((int)arguments.length));
        if (arguments.length > 0) {
            for (int i = 0; i < arguments.length; ++i) {
                matcher = matcher.and((ElementMatcher)(CustomizeUtil.isJavaClass(arguments[i]) ? ElementMatchers.takesArgument((int)i, (Class)CustomizeUtil.getJavaClass(arguments[i])) : ArgumentTypeNameMatch.takesArgumentWithType((int)i, (String)arguments[i])));
            }
        }
        return matcher;
    }

    public ElementMatcher getInterceptPoints(String enhanceClass, boolean isStatic) {
        HashMap<String, ElementMatcher> enhanceClasses = this.getEnhanceClasses();
        return enhanceClasses.get(CustomizeUtil.generateClassDesc(enhanceClass, isStatic));
    }

    public Set<String> getInstrumentations() {
        HashMap<String, ElementMatcher> enhanceClasses = this.getEnhanceClasses();
        return enhanceClasses.keySet();
    }

    private HashMap<String, ElementMatcher> getEnhanceClasses() {
        return (HashMap)Config.Plugin.Customize.CONTEXT.get("CONTEXT_ENHANCE_CLASSES");
    }

    public Map<String, Object> getConfiguration(Method method) {
        return this.getMethodConfigurations().get(MethodUtil.generateOperationName((Method)method));
    }

    static {
        logger = LogManager.getLogger(CustomizeConfiguration.class);
    }
}

