/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.util.failover;

import com.google.common.net.HostAndPort;
import com.orbitz.consul.ConsulException;
import com.orbitz.consul.util.failover.strategy.BlacklistingConsulFailoverStrategy;
import com.orbitz.consul.util.failover.strategy.ConsulFailoverStrategy;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class ConsulFailoverInterceptor
implements Interceptor {
    private ConsulFailoverStrategy strategy;

    public ConsulFailoverInterceptor(Collection<HostAndPort> targets, long timeout) {
        this(new BlacklistingConsulFailoverStrategy(targets, timeout));
    }

    public ConsulFailoverInterceptor(ConsulFailoverStrategy strategy) {
        this.strategy = strategy;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request originalRequest = chain.request();
        if (this.strategy.isRequestViable(originalRequest)) {
            Optional<Request> nextRequest;
            Request previousRequest = originalRequest;
            Response previousResponse = null;
            while ((nextRequest = this.strategy.computeNextStage(previousRequest, previousResponse)).isPresent()) {
                try {
                    Response lastResponse = chain.proceed(nextRequest.get());
                    if (lastResponse.isSuccessful()) {
                        return lastResponse;
                    }
                    previousResponse = lastResponse;
                    previousRequest = nextRequest.get();
                }
                catch (Exception ex) {
                    this.strategy.markRequestFailed(nextRequest.get());
                }
            }
            throw new ConsulException("Unable to successfully determine a viable host for communication.");
        }
        throw new ConsulException("Consul failover strategy has determined that there are no viable hosts remaining.");
    }
}

