/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.logging.log4j2;

import com.alibaba.nacos.client.logging.AbstractNacosLogging;
import com.alibaba.nacos.client.utils.StringUtils;
import com.alibaba.nacos.common.util.ClassUtils;
import com.alibaba.nacos.common.util.ResourceUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.composite.CompositeConfiguration;
import org.apache.logging.log4j.core.lookup.Interpolator;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.util.PropertiesUtil;

public class Log4J2NacosLogging
extends AbstractNacosLogging {
    private static final String NACOS_LOG4J2_LOCATION = "classpath:nacos-log4j2.xml";
    private static final String FILE_PROTOCOL = "file";
    private static final String YAML_PARSER_CLASS_NAME = "com.fasterxml.jackson.dataformat.yaml.YAMLParser";
    private static final String JSON_PARSER_CLASS_NAME = "com.fasterxml.jackson.databind.ObjectMapper";
    private final StrSubstitutor strSubstitutor = new StrSubstitutor((StrLookup)new Interpolator());
    private Set<String> locationList = new HashSet<String>();

    public Log4J2NacosLogging() {
        String location = this.getLocation(NACOS_LOG4J2_LOCATION);
        if (!StringUtils.isBlank(location)) {
            this.locationList.add(location);
        }
    }

    @Override
    public void loadConfiguration() {
        if (this.locationList.isEmpty()) {
            return;
        }
        List<String> configList = this.findConfig(this.getCurrentlySupportedConfigLocations());
        if (configList != null) {
            this.locationList.addAll(configList);
        }
        ArrayList<AbstractConfiguration> configurations = new ArrayList<AbstractConfiguration>();
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        for (String location : this.locationList) {
            try {
                Configuration configuration = this.loadConfiguration(loggerContext, location);
                if (!(configuration instanceof AbstractConfiguration)) continue;
                configurations.add((AbstractConfiguration)configuration);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not initialize Log4J2 Nacos logging from " + location, e);
            }
        }
        CompositeConfiguration compositeConfiguration = new CompositeConfiguration(configurations);
        loggerContext.start((Configuration)compositeConfiguration);
    }

    private Configuration loadConfiguration(LoggerContext loggerContext, String location) {
        try {
            URL url = ResourceUtils.getResourceURL((String)location);
            ConfigurationSource source = this.getConfigurationSource(url);
            return ConfigurationFactory.getInstance().getConfiguration(loggerContext, source);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not initialize Log4J2 logging from " + location, e);
        }
    }

    private ConfigurationSource getConfigurationSource(URL url) throws IOException {
        InputStream stream = url.openStream();
        if (FILE_PROTOCOL.equals(url.getProtocol())) {
            return new ConfigurationSource(stream, ResourceUtils.getResourceAsFile((URL)url));
        }
        return new ConfigurationSource(stream, url);
    }

    private String[] getCurrentlySupportedConfigLocations() {
        ArrayList<String> supportedConfigLocations = new ArrayList<String>();
        if (ClassUtils.isPresent((String)YAML_PARSER_CLASS_NAME)) {
            Collections.addAll(supportedConfigLocations, "log4j2.yaml", "log4j2.yml", "log4j2-test.yaml", "log4j2-test.yml");
        }
        if (ClassUtils.isPresent((String)JSON_PARSER_CLASS_NAME)) {
            Collections.addAll(supportedConfigLocations, "log4j2.json", "log4j2.jsn", "log4j2-test.json", "log4j2-test.jsn");
        }
        supportedConfigLocations.add("log4j2.xml");
        supportedConfigLocations.add("log4j2-test.xml");
        return supportedConfigLocations.toArray(new String[supportedConfigLocations.size()]);
    }

    private List<String> findConfig(String[] locations) {
        String configLocationStr = this.strSubstitutor.replace(PropertiesUtil.getProperties().getStringProperty("log4j.configurationFile"));
        if (configLocationStr != null) {
            return Arrays.asList(configLocationStr.split(","));
        }
        for (String location : locations) {
            ClassLoader defaultClassLoader = ClassUtils.getDefaultClassLoader();
            if (defaultClassLoader == null || defaultClassLoader.getResource(location) == null) continue;
            ArrayList<String> list = new ArrayList<String>();
            list.add("classpath:" + location);
            return list;
        }
        return null;
    }
}

