/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.module;

import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.ModuleServiceHolder;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;

public abstract class ModuleProvider
implements ModuleServiceHolder {
    private ModuleManager manager;
    private ModuleDefine moduleDefine;
    private final Map<Class<? extends Service>, Service> services = new HashMap<Class<? extends Service>, Service>();

    protected final ModuleManager getManager() {
        return this.manager;
    }

    public abstract String name();

    public abstract Class<? extends ModuleDefine> module();

    public abstract ModuleConfig createConfigBeanIfAbsent();

    public abstract void prepare() throws ServiceNotProvidedException, ModuleStartException;

    public abstract void start() throws ServiceNotProvidedException, ModuleStartException;

    public abstract void notifyAfterCompleted() throws ServiceNotProvidedException, ModuleStartException;

    public abstract String[] requiredModules();

    @Override
    public final void registerServiceImplementation(Class<? extends Service> serviceType, Service service) throws ServiceNotProvidedException {
        if (!serviceType.isInstance(service)) {
            throw new ServiceNotProvidedException(serviceType + " is not implemented by " + service);
        }
        this.services.put(serviceType, service);
    }

    void requiredCheck(Class<? extends Service>[] requiredServices) throws ServiceNotProvidedException {
        if (requiredServices == null) {
            return;
        }
        for (Class<? extends Service> service : requiredServices) {
            if (this.services.containsKey(service)) continue;
            throw new ServiceNotProvidedException("Service:" + service.getName() + " not provided");
        }
        if (requiredServices.length != this.services.size()) {
            throw new ServiceNotProvidedException("The " + this.name() + " provider in " + this.moduleDefine.name() + " moduleDefine provide more service implementations than ModuleDefine requirements.");
        }
    }

    @Override
    public <T extends Service> T getService(Class<T> serviceType) throws ServiceNotProvidedException {
        Service serviceImpl = this.services.get(serviceType);
        if (serviceImpl != null) {
            return (T)serviceImpl;
        }
        throw new ServiceNotProvidedException("Service " + serviceType.getName() + " should not be provided, based on moduleDefine define.");
    }

    ModuleDefine getModule() {
        return this.moduleDefine;
    }

    String getModuleName() {
        return this.moduleDefine.name();
    }

    public void setManager(ModuleManager manager) {
        this.manager = manager;
    }

    public void setModuleDefine(ModuleDefine moduleDefine) {
        this.moduleDefine = moduleDefine;
    }
}

