/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.esjob;

import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.executor.ShardingContexts;
import com.google.common.base.Strings;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class JobExecutorInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        ShardingContexts shardingContexts = (ShardingContexts)allArguments[0];
        Integer item = (Integer)allArguments[1];
        ShardingContext shardingContext = new ShardingContext(shardingContexts, item.intValue());
        String operateName = shardingContext.getJobName();
        if (!Strings.isNullOrEmpty((String)shardingContext.getShardingParameter())) {
            operateName = operateName + "-" + shardingContext.getShardingParameter();
        }
        AbstractSpan span = ContextManager.createLocalSpan((String)operateName);
        span.setComponent((Component)ComponentsDefine.ELASTIC_JOB);
        span.tag("sharding_context", shardingContext.toString());
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().errorOccurred().log(t);
    }
}

