/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.jvm.provider.handler;

import io.grpc.stub.StreamObserver;
import org.apache.skywalking.apm.network.language.agent.Downstream;
import org.apache.skywalking.apm.network.language.agent.JVMMetric;
import org.apache.skywalking.apm.network.language.agent.JVMMetrics;
import org.apache.skywalking.apm.network.language.agent.JVMMetricsServiceGrpc;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCHandler;
import org.apache.skywalking.oap.server.receiver.jvm.provider.handler.JVMSourceDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JVMMetricsServiceHandler
extends JVMMetricsServiceGrpc.JVMMetricsServiceImplBase
implements GRPCHandler {
    private static final Logger logger = LoggerFactory.getLogger(JVMMetricsServiceHandler.class);
    private final JVMSourceDispatcher jvmSourceDispatcher;

    public JVMMetricsServiceHandler(ModuleManager moduleManager) {
        this.jvmSourceDispatcher = new JVMSourceDispatcher(moduleManager);
    }

    public void collect(JVMMetrics request, StreamObserver<Downstream> responseObserver) {
        int serviceInstanceId = request.getApplicationInstanceId();
        if (logger.isDebugEnabled()) {
            logger.debug("receive the jvm metrics from service instance, id: {}", (Object)serviceInstanceId);
        }
        request.getMetricsList().forEach(metrics -> {
            long minuteTimeBucket = TimeBucket.getMinuteTimeBucket((long)metrics.getTime());
            this.jvmSourceDispatcher.sendMetric(serviceInstanceId, minuteTimeBucket, (JVMMetric)metrics);
        });
        responseObserver.onNext((Object)Downstream.newBuilder().build());
        responseObserver.onCompleted();
    }
}

