/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.jvm.provider.handler;

import io.grpc.stub.StreamObserver;
import org.apache.skywalking.apm.network.common.Commands;
import org.apache.skywalking.apm.network.language.agent.JVMMetric;
import org.apache.skywalking.apm.network.language.agent.v2.JVMMetricCollection;
import org.apache.skywalking.apm.network.language.agent.v2.JVMMetricReportServiceGrpc;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCHandler;
import org.apache.skywalking.oap.server.receiver.jvm.provider.handler.JVMSourceDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JVMMetricReportServiceHandler
extends JVMMetricReportServiceGrpc.JVMMetricReportServiceImplBase
implements GRPCHandler {
    private static final Logger logger = LoggerFactory.getLogger(JVMMetricReportServiceHandler.class);
    private final JVMSourceDispatcher jvmSourceDispatcher;

    public JVMMetricReportServiceHandler(ModuleManager moduleManager) {
        this.jvmSourceDispatcher = new JVMSourceDispatcher(moduleManager);
    }

    public void collect(JVMMetricCollection request, StreamObserver<Commands> responseObserver) {
        int serviceInstanceId = request.getServiceInstanceId();
        if (logger.isDebugEnabled()) {
            logger.debug("receive the jvm metrics from service instance, id: {}", (Object)serviceInstanceId);
        }
        request.getMetricsList().forEach(metrics -> {
            long minuteTimeBucket = TimeBucket.getMinuteTimeBucket((long)metrics.getTime());
            this.jvmSourceDispatcher.sendMetric(serviceInstanceId, minuteTimeBucket, (JVMMetric)metrics);
        });
        responseObserver.onNext((Object)Commands.newBuilder().build());
        responseObserver.onCompleted();
    }
}

