/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.vertx3;

import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;

class VertxContext {
    public static final String STOP_SPAN_NECESSARY = "VERTX_STOP_SPAN_NECESSARY";
    private static final Map<String, Stack<VertxContext>> CONTEXT_MAP = new ConcurrentHashMap<String, Stack<VertxContext>>();
    private final ContextSnapshot contextSnapshot;
    private final AbstractSpan span;

    static void pushContext(String identifier, VertxContext vertxContext) {
        if (!CONTEXT_MAP.containsKey(identifier)) {
            CONTEXT_MAP.put(identifier, new Stack());
        }
        CONTEXT_MAP.get(identifier).push(vertxContext);
    }

    static VertxContext popContext(String identifier) {
        Stack<VertxContext> stack = CONTEXT_MAP.get(identifier);
        VertxContext context = stack.pop();
        if (stack.isEmpty()) {
            CONTEXT_MAP.remove(identifier);
        }
        return context;
    }

    static VertxContext peekContext(String identifier) {
        return CONTEXT_MAP.get(identifier).peek();
    }

    static boolean hasContext(String identifier) {
        return identifier != null && CONTEXT_MAP.containsKey(identifier);
    }

    VertxContext(ContextSnapshot contextSnapshot, AbstractSpan span) {
        this.contextSnapshot = contextSnapshot;
        this.span = span;
    }

    ContextSnapshot getContextSnapshot() {
        return this.contextSnapshot;
    }

    AbstractSpan getSpan() {
        return this.span;
    }
}

