/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.vertx3;

import io.vertx.core.http.HttpServerRequest;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.vertx3.VertxContext;

public class RouterImplAcceptInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        HttpServerRequest request = (HttpServerRequest)allArguments[0];
        ContextCarrier contextCarrier = new ContextCarrier();
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            next.setHeadValue(request.headers().get(next.getHeadKey()));
            request.headers().remove(next.getHeadKey());
        }
        AbstractSpan span = ContextManager.createEntrySpan((String)RouterImplAcceptInterceptor.toPath(request.uri()), (ContextCarrier)contextCarrier);
        span.setComponent((Component)ComponentsDefine.VERTX);
        SpanLayer.asHttp((AbstractSpan)span);
        Tags.HTTP.METHOD.set(span, request.method().toString());
        Tags.URL.set(span, request.uri());
        ((EnhancedInstance)request.response()).setSkyWalkingDynamicField((Object)new VertxContext(ContextManager.capture(), span.prepareForAsync()));
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().errorOccurred().log(t);
    }

    private static String toPath(String uri) {
        int index = uri.indexOf("?");
        if (index > -1) {
            return uri.substring(0, index);
        }
        return uri;
    }
}

