/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.vertx3;

import io.vertx.core.http.HttpClientRequest;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.vertx3.VertxContext;

public class HttpClientRequestImplEndInterceptor
implements InstanceMethodsAroundInterceptor,
InstanceConstructorInterceptor {
    public void onConstruct(EnhancedInstance objInst, Object[] allArguments) {
        int port;
        String host;
        if (allArguments[3] instanceof Integer) {
            host = (String)allArguments[2];
            port = (Integer)allArguments[3];
        } else {
            host = (String)allArguments[3];
            port = (Integer)allArguments[4];
        }
        objInst.setSkyWalkingDynamicField((Object)(host + ":" + port));
    }

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        HttpClientRequest request = (HttpClientRequest)objInst;
        ContextCarrier contextCarrier = new ContextCarrier();
        AbstractSpan span = ContextManager.createExitSpan((String)HttpClientRequestImplEndInterceptor.toPath(request.uri()), (ContextCarrier)contextCarrier, (String)((String)objInst.getSkyWalkingDynamicField()));
        span.setComponent((Component)ComponentsDefine.VERTX);
        SpanLayer.asHttp((AbstractSpan)span);
        Tags.HTTP.METHOD.set(span, request.method().toString());
        Tags.URL.set(span, request.uri());
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            request.headers().add(next.getHeadKey(), next.getHeadValue());
        }
        objInst.setSkyWalkingDynamicField((Object)new VertxContext(ContextManager.capture(), span.prepareForAsync()));
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().errorOccurred().log(t);
    }

    private static String toPath(String uri) {
        int index = uri.indexOf("?");
        if (index > -1) {
            return uri.substring(0, index);
        }
        return uri;
    }
}

