/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.vertx3;

import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.impl.clustered.ClusteredMessage;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.vertx3.VertxContext;

public class EventBusImplDeliverToHandlerInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        boolean isFromWire;
        ContextManager.getRuntimeContext().remove((Object)("VERTX_STOP_SPAN_NECESSARY." + this.getClass().getName()));
        Message message = (Message)allArguments[0];
        boolean bl = isFromWire = message instanceof ClusteredMessage && ((ClusteredMessage)message).isFromWire();
        if (!isFromWire && VertxContext.hasContext(message.address())) {
            VertxContext context = VertxContext.popContext(message.address());
            context.getSpan().asyncFinish();
        } else if (!isFromWire) {
            AbstractSpan span;
            if (VertxContext.hasContext(message.replyAddress())) {
                VertxContext context = VertxContext.peekContext(message.replyAddress());
                span = ContextManager.createLocalSpan((String)context.getContextSnapshot().getParentOperationName());
                ContextManager.continued((ContextSnapshot)context.getContextSnapshot());
            } else {
                span = ContextManager.createLocalSpan((String)message.address());
            }
            span.setComponent((Component)ComponentsDefine.VERTX);
            SpanLayer.asRPCFramework((AbstractSpan)span);
            if (message.replyAddress() != null) {
                VertxContext.pushContext(message.replyAddress(), new VertxContext(ContextManager.capture(), span.prepareForAsync()));
            }
            ContextManager.getRuntimeContext().put((Object)("VERTX_STOP_SPAN_NECESSARY." + this.getClass().getName()), (Object)true);
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        Boolean closeSpan = (Boolean)ContextManager.getRuntimeContext().get((Object)("VERTX_STOP_SPAN_NECESSARY." + this.getClass().getName()));
        if (Boolean.TRUE.equals(closeSpan)) {
            ContextManager.stopSpan();
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().errorOccurred().log(t);
    }
}

