/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.vertx3;

import io.vertx.core.eventbus.impl.clustered.ClusteredMessage;
import io.vertx.core.net.impl.ServerID;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.vertx3.VertxContext;

public class ClusteredEventBusSendRemoteInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        ContextManager.getRuntimeContext().remove((Object)("VERTX_STOP_SPAN_NECESSARY." + this.getClass().getName()));
        ClusteredMessage message = (ClusteredMessage)allArguments[1];
        if (VertxContext.hasContext(message.address())) {
            VertxContext context = VertxContext.popContext(message.address());
            context.getSpan().asyncFinish();
        } else {
            ServerID sender = (ServerID)allArguments[0];
            ContextCarrier contextCarrier = new ContextCarrier();
            AbstractSpan span = ContextManager.createExitSpan((String)message.address(), (ContextCarrier)contextCarrier, (String)sender.toString());
            span.setComponent((Component)ComponentsDefine.VERTX);
            SpanLayer.asRPCFramework((AbstractSpan)span);
            CarrierItem next = contextCarrier.items();
            while (next.hasNext()) {
                next = next.next();
                message.headers().add(next.getHeadKey(), next.getHeadValue());
            }
            if (message.replyAddress() != null) {
                VertxContext.pushContext(message.replyAddress(), new VertxContext(ContextManager.capture(), span.prepareForAsync()));
            }
            ContextManager.getRuntimeContext().put((Object)("VERTX_STOP_SPAN_NECESSARY." + this.getClass().getName()), (Object)true);
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        Boolean closeSpan = (Boolean)ContextManager.getRuntimeContext().get((Object)("VERTX_STOP_SPAN_NECESSARY." + this.getClass().getName()));
        if (Boolean.TRUE.equals(closeSpan)) {
            ContextManager.stopSpan();
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().errorOccurred().log(t);
    }
}

